/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class X509SubjectAlternativeNameUPNPrincipalResolver
extends AbstractX509PrincipalResolver {
    public static final String UPN_OBJECTID = "1.3.6.1.4.1.311.20.2.3";

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        this.logger.debug("Resolving principal from Subject Alternative Name UPN for {}", (Object)certificate);
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> sanItem : subjectAltNames) {
                    ASN1Sequence seq = this.getAltnameSequence(sanItem);
                    String upnString = X509SubjectAlternativeNameUPNPrincipalResolver.getUPNStringFromSequence(seq);
                    if (upnString == null) continue;
                    return upnString;
                }
            }
        }
        catch (CertificateParsingException e) {
            this.logger.error("Error is encountered while trying to retrieve subject alternative names collection from certificate", (Throwable)e);
            this.logger.debug("Returning null principal...");
            return null;
        }
        this.logger.debug("Returning null principal id...");
        return null;
    }

    private static String getUPNStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))) != null && UPN_OBJECTID.equals(id.getId())) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1Primitive prim = obj.getObject();
            if (prim instanceof ASN1TaggedObject) {
                prim = ASN1TaggedObject.getInstance((Object)prim).getObject();
            }
            if (prim instanceof ASN1OctetString) {
                return new String(((ASN1OctetString)prim).getOctets(), StandardCharsets.UTF_8);
            }
            if (prim instanceof ASN1String) {
                return ((ASN1String)prim).getString();
            }
            return null;
        }
        return null;
    }

    private ASN1Sequence getAltnameSequence(List sanItem) {
        Integer itemType;
        if (sanItem.size() < 2) {
            this.logger.error("Subject Alternative Name List does not contain at least two required elements. Returning null principal id...");
        }
        if ((itemType = (Integer)sanItem.get(0)) == 0) {
            byte[] altName = (byte[])sanItem.get(1);
            return this.getAltnameSequence(altName);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ASN1Sequence getAltnameSequence(byte[] sanValue) {
        ASN1Primitive oct = null;
        try (ByteArrayInputStream bInput = new ByteArrayInputStream(sanValue);){
            try (ASN1InputStream input = new ASN1InputStream((InputStream)bInput);){
                oct = input.readObject();
            }
            catch (IOException e) {
                this.logger.error("Error on getting Alt Name as a DERSEquence: {}", (Object)e.getMessage(), (Object)e);
            }
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)oct);
            return aSN1Sequence;
        }
        catch (IOException e) {
            this.logger.error("An error has occurred while reading the subject alternative name value", (Throwable)e);
            return null;
        }
    }
}

