/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.AttributeType;
import org.cryptacular.x509.dn.NameReader;
import org.cryptacular.x509.dn.RDN;
import org.cryptacular.x509.dn.RDNSequence;
import org.cryptacular.x509.dn.StandardAttributeType;

public class X509SubjectPrincipalResolver
extends AbstractX509PrincipalResolver {
    private static final Pattern ATTR_PATTERN = Pattern.compile("\\$(\\w+)");
    private String descriptor;

    public void setDescriptor(String s) {
        this.descriptor = s;
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        this.logger.debug("Resolving principal for {}", (Object)certificate);
        StringBuffer sb = new StringBuffer();
        Matcher m = ATTR_PATTERN.matcher(this.descriptor);
        HashMap<String, AttributeContext> attrMap = new HashMap<String, AttributeContext>();
        RDNSequence rdnSequence = new NameReader(certificate).readSubject();
        while (m.find()) {
            String name = m.group(1);
            if (!attrMap.containsKey(name)) {
                String[] values = X509SubjectPrincipalResolver.getAttributeValues(rdnSequence, StandardAttributeType.fromName((String)name));
                attrMap.put(name, new AttributeContext(values));
            }
            AttributeContext context = (AttributeContext)attrMap.get(name);
            m.appendReplacement(sb, context.nextValue());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String[] getAttributeValues(RDNSequence rdnSequence, AttributeType attribute) {
        ArrayList<String> values = new ArrayList<String>();
        for (RDN rdn : rdnSequence.backward()) {
            for (Attribute attr : rdn.getAttributes()) {
                if (!attr.getType().equals(attribute)) continue;
                values.add(attr.getValue());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    private static class AttributeContext {
        private int currentIndex;
        private final String[] values;

        AttributeContext(String[] values) {
            this.values = values;
        }

        public String nextValue() {
            if (this.currentIndex == this.values.length) {
                throw new IllegalStateException("No values remaining for attribute");
            }
            return this.values[this.currentIndex++];
        }
    }
}

