/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.checker;

import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apereo.cas.adaptors.x509.authentication.revocation.RevokedCertificateException;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.RevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.DenyRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.ThresholdExpiredCRLRevocationPolicy;
import org.apereo.cas.adaptors.x509.util.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCRLRevocationChecker
implements RevocationChecker {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean checkAll;
    private RevocationPolicy<Void> unavailableCRLPolicy;
    private RevocationPolicy<X509CRL> expiredCRLPolicy;

    @PostConstruct
    public void init() {
        if (this.unavailableCRLPolicy == null) {
            this.unavailableCRLPolicy = new DenyRevocationPolicy();
        }
        if (this.expiredCRLPolicy == null) {
            this.expiredCRLPolicy = new ThresholdExpiredCRLRevocationPolicy();
        }
    }

    @Override
    public void check(X509Certificate cert) throws GeneralSecurityException {
        if (cert == null) {
            throw new IllegalArgumentException("Certificate cannot be null.");
        }
        this.logger.debug("Evaluating certificate revocation status for {}", (Object)CertUtils.toString(cert));
        Collection<X509CRL> crls = this.getCRLs(cert);
        if (crls == null || crls.isEmpty()) {
            this.logger.warn("CRL data is not available for {}", (Object)CertUtils.toString(cert));
            this.unavailableCRLPolicy.apply(null);
            return;
        }
        ArrayList expiredCrls = new ArrayList();
        ArrayList<X509CRLEntry> revokedCrls = new ArrayList<X509CRLEntry>();
        crls.stream().filter(CertUtils::isExpired).forEach(crl -> {
            this.logger.warn("CRL data expired on {}", (Object)crl.getNextUpdate());
            expiredCrls.add(crl);
        });
        if (crls.size() == expiredCrls.size()) {
            this.logger.warn("All CRLs retrieved have expired. Applying CRL expiration policy...");
            for (X509CRL crl2 : expiredCrls) {
                this.expiredCRLPolicy.apply(crl2);
            }
        } else {
            crls.removeAll(expiredCrls);
            this.logger.debug("Valid CRLs [{}] found that are not expired yet", crls);
            for (X509CRL crl3 : crls) {
                X509CRLEntry entry = crl3.getRevokedCertificate(cert);
                if (entry == null) continue;
                revokedCrls.add(entry);
            }
            if (revokedCrls.size() == crls.size()) {
                X509CRLEntry entry = (X509CRLEntry)revokedCrls.get(0);
                this.logger.warn("All CRL entries have been revoked. Rejecting the first entry [{}]", (Object)entry);
                throw new RevokedCertificateException(entry);
            }
        }
    }

    public void setUnavailableCRLPolicy(RevocationPolicy<Void> policy) {
        this.unavailableCRLPolicy = policy;
    }

    public void setExpiredCRLPolicy(RevocationPolicy<X509CRL> policy) {
        this.expiredCRLPolicy = policy;
    }

    public RevocationPolicy<Void> getUnavailableCRLPolicy() {
        return this.unavailableCRLPolicy;
    }

    public RevocationPolicy<X509CRL> getExpiredCRLPolicy() {
        return this.expiredCRLPolicy;
    }

    public void setCheckAll(boolean checkAll) {
        this.checkAll = checkAll;
    }

    public X509CRL getCRL(X509Certificate cert) {
        Collection<X509CRL> list = this.getCRLs(cert);
        if (list != null && !list.isEmpty()) {
            return list.iterator().next();
        }
        this.logger.debug("No CRL could be found for {}", (Object)CertUtils.toString(cert));
        return null;
    }

    protected abstract boolean addCRL(Object var1, X509CRL var2);

    protected abstract Collection<X509CRL> getCRLs(X509Certificate var1);
}

