/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.checker;

import com.google.common.base.Throwables;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.AbstractCRLRevocationChecker;
import org.apereo.cas.adaptors.x509.util.CertUtils;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.cryptacular.x509.ExtensionReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class CRLDistributionPointRevocationChecker
extends AbstractCRLRevocationChecker {
    private Cache crlCache;
    private CRLFetcher fetcher;
    private boolean throwOnFetchFailure;

    public CRLDistributionPointRevocationChecker() {
    }

    public CRLDistributionPointRevocationChecker(Cache crlCache) {
        this(crlCache, new ResourceCRLFetcher());
    }

    public CRLDistributionPointRevocationChecker(Cache crlCache, boolean throwOnFetchFailure) {
        this(crlCache, new ResourceCRLFetcher());
        this.setThrowOnFetchFailure(throwOnFetchFailure);
    }

    public CRLDistributionPointRevocationChecker(Cache crlCache, CRLFetcher fetcher) {
        this.crlCache = crlCache;
        this.fetcher = fetcher;
    }

    public void setThrowOnFetchFailure(boolean throwOnFetchFailure) {
        this.throwOnFetchFailure = throwOnFetchFailure;
    }

    protected List<X509CRL> getCRLs(X509Certificate cert) {
        if (this.crlCache == null) {
            throw new IllegalArgumentException("CRL cache is not defined");
        }
        if (this.fetcher == null) {
            throw new IllegalArgumentException("CRL fetcher is not defined");
        }
        if (this.getExpiredCRLPolicy() == null) {
            throw new IllegalArgumentException("Expiration CRL policy is not defined");
        }
        if (this.getUnavailableCRLPolicy() == null) {
            throw new IllegalArgumentException("Unavailable CRL policy is not defined");
        }
        URI[] urls = this.getDistributionPoints(cert);
        this.logger.debug("Distribution points for {}: {}.", (Object)CertUtils.toString(cert), Arrays.asList(urls));
        ArrayList<X509CRL> listOfLocations = new ArrayList<X509CRL>(urls.length);
        boolean stopFetching = false;
        try {
            for (int index = 0; !stopFetching && index < urls.length; ++index) {
                block14: {
                    URI url = urls[index];
                    Element item = this.crlCache.get((Serializable)url);
                    if (item != null) {
                        this.logger.debug("Found CRL in cache for {}", (Object)CertUtils.toString(cert));
                        byte[] encodedCrl = (byte[])item.getObjectValue();
                        X509CRL crlFetched = this.fetcher.fetch((Resource)new ByteArrayResource(encodedCrl));
                        if (crlFetched != null) {
                            listOfLocations.add(crlFetched);
                        } else {
                            this.logger.warn("Could fetch X509 CRL for {}. Returned value is null", (Object)url);
                        }
                    } else {
                        this.logger.debug("CRL for {} is not cached. Fetching and caching...", (Object)CertUtils.toString(cert));
                        try {
                            X509CRL crl = this.fetcher.fetch(url);
                            if (crl != null) {
                                this.logger.info("Success. Caching fetched CRL at {}.", (Object)url);
                                this.addCRL(url, crl);
                                listOfLocations.add(crl);
                            }
                        }
                        catch (Exception e) {
                            this.logger.error("Error fetching CRL at {}", (Object)url, (Object)e);
                            if (!this.throwOnFetchFailure) break block14;
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                }
                if (this.checkAll || listOfLocations.isEmpty()) continue;
                this.logger.debug("CRL fetching is configured to not check all locations.");
                stopFetching = true;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.logger.debug("Found {} CRLs", (Object)listOfLocations.size());
        return listOfLocations;
    }

    @Override
    protected boolean addCRL(Object id, X509CRL crl) {
        try {
            if (crl == null) {
                this.logger.debug("No CRL was passed. Removing {} from cache...", id);
                return this.crlCache.remove(id);
            }
            this.crlCache.put(new Element(id, (Object)crl.getEncoded()));
            return this.crlCache.get(id) != null;
        }
        catch (Exception e) {
            this.logger.warn("Failed to add the crl entry [{}] to the cache", (Object)crl);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private URI[] getDistributionPoints(X509Certificate cert) {
        List points;
        try {
            points = new ExtensionReader(cert).readCRLDistributionPoints();
        }
        catch (RuntimeException e) {
            this.logger.error("Error reading CRLDistributionPoints extension field on {}", (Object)CertUtils.toString(cert), (Object)e);
            return new URI[0];
        }
        ArrayList<URI> urls = new ArrayList<URI>();
        if (points != null) {
            for (DistributionPoint point : points) {
                DistributionPointName pointName = point.getDistributionPoint();
                if (pointName == null) continue;
                ASN1Sequence nameSequence = ASN1Sequence.getInstance((Object)pointName.getName());
                for (int i = 0; i < nameSequence.size(); ++i) {
                    GeneralName name = GeneralName.getInstance((Object)nameSequence.getObjectAt(i));
                    this.logger.debug("Found CRL distribution point {}.", (Object)name);
                    try {
                        this.addURL(urls, DERIA5String.getInstance((Object)name.getName()).getString());
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("{} not supported. String or GeneralNameList expected.", (Object)pointName);
                    }
                }
            }
        }
        return urls.toArray(new URI[urls.size()]);
    }

    private void addURL(List<URI> list, String uriString) {
        try {
            URI uri;
            try {
                URL url = new URL(URLDecoder.decode(uriString, StandardCharsets.UTF_8.name()));
                uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null);
            }
            catch (MalformedURLException e) {
                uri = new URI(uriString);
            }
            list.add(uri);
        }
        catch (Exception e) {
            this.logger.warn("{} is not a valid distribution point URI.", (Object)uriString);
        }
    }
}

