/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.checker;

import com.google.common.base.Throwables;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.security.auth.x500.X500Principal;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.AbstractCRLRevocationChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ResourceCRLRevocationChecker
extends AbstractCRLRevocationChecker {
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int refreshInterval = 3600;
    private CRLFetcher fetcher;
    private Map<X500Principal, X509CRL> crlIssuerMap = Collections.synchronizedMap(new HashMap());
    private Set<Resource> resources;

    public ResourceCRLRevocationChecker() {
    }

    public ResourceCRLRevocationChecker(Resource crl) {
        this(new Resource[]{crl});
    }

    public ResourceCRLRevocationChecker(Resource[] crls) {
        this(new ResourceCRLFetcher(), crls);
    }

    public ResourceCRLRevocationChecker(CRLFetcher fetcher, Resource[] crls) {
        this.fetcher = fetcher;
        this.resources = Stream.of(crls).collect(Collectors.toSet());
    }

    public void setRefreshInterval(int seconds) {
        this.refreshInterval = seconds;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        if (!this.validateConfiguration()) {
            return;
        }
        try {
            Set<X509CRL> results = this.fetcher.fetch(this.getResources());
            this.addCrls(results);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Runnable scheduledFetcher = new Runnable(){
            private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

            @Override
            public void run() {
                try {
                    Set<Resource> resources = ResourceCRLRevocationChecker.this.getResources();
                    Set<X509CRL> results = ResourceCRLRevocationChecker.this.getFetcher().fetch(resources);
                    ResourceCRLRevocationChecker.this.addCrls(results);
                }
                catch (Exception e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        };
        try {
            this.scheduler.scheduleAtFixedRate(scheduledFetcher, this.refreshInterval, this.refreshInterval, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean validateConfiguration() {
        if (this.resources == null || this.resources.isEmpty()) {
            this.logger.debug("{} is not configured with resources. Skipping configuration...", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.fetcher == null) {
            this.logger.debug("{} is not configured with a CRL fetcher. Skipping configuration...", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.getExpiredCRLPolicy() == null) {
            this.logger.debug("{} is not configured with a CRL expiration policy. Skipping configuration...", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.getUnavailableCRLPolicy() == null) {
            this.logger.debug("{} is not configured with a CRL unavailable policy. Skipping configuration...", (Object)this.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    private void addCrls(Set<X509CRL> results) {
        for (X509CRL entry : results) {
            this.addCRL(entry.getIssuerX500Principal(), entry);
        }
    }

    protected CRLFetcher getFetcher() {
        return this.fetcher;
    }

    protected Set<Resource> getResources() {
        return this.resources;
    }

    @Override
    protected boolean addCRL(Object issuer, X509CRL crl) {
        this.logger.debug("Adding CRL for issuer {}", issuer);
        this.crlIssuerMap.put((X500Principal)issuer, crl);
        return this.crlIssuerMap.containsKey(issuer);
    }

    @Override
    protected Collection<X509CRL> getCRLs(X509Certificate cert) {
        X500Principal principal = cert.getIssuerX500Principal();
        if (this.crlIssuerMap.containsKey(principal)) {
            return Collections.singleton(this.crlIssuerMap.get(principal));
        }
        this.logger.warn("Could not locate CRL for issuer principal {}", (Object)principal);
        return Collections.emptyList();
    }

    @PreDestroy
    public void shutdown() {
        this.scheduler.shutdown();
    }

    public void setFetcher(CRLFetcher fetcher) {
        this.fetcher = fetcher;
    }
}

