/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.policy;

import java.security.cert.X509CRL;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apereo.cas.adaptors.x509.authentication.ExpiredCRLException;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.adaptors.x509.util.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdExpiredCRLRevocationPolicy
implements RevocationPolicy<X509CRL> {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private int threshold;

    @Override
    public void apply(X509CRL crl) throws ExpiredCRLException {
        ZonedDateTime cutoff = ZonedDateTime.now(ZoneOffset.UTC);
        if (CertUtils.isExpired(crl, cutoff)) {
            if (CertUtils.isExpired(crl, cutoff.minusSeconds(this.threshold))) {
                throw new ExpiredCRLException(crl.toString(), cutoff, this.threshold);
            }
            this.logger.info(String.format("CRL expired on %s but is within threshold period, %s seconds.", crl.getNextUpdate(), this.threshold));
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

