/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.config;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.sf.ehcache.Cache;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.handler.support.X509CredentialsAuthenticationHandler;
import org.apereo.cas.adaptors.x509.authentication.ldap.LdaptiveResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SerialNumberAndIssuerDNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SerialNumberPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectAlternativeNameUPNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectDNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.CRLDistributionPointRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.NoOpRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.ResourceCRLRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.RevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.AllowRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.DenyRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.ThresholdExpiredCRLRevocationPolicy;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.x509.X509Properties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration(value="x509AuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class X509AuthenticationConfiguration {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public RevocationPolicy allowRevocationPolicy() {
        return new AllowRevocationPolicy();
    }

    @Bean
    @RefreshScope
    public RevocationPolicy thresholdExpiredCRLRevocationPolicy() {
        ThresholdExpiredCRLRevocationPolicy p = new ThresholdExpiredCRLRevocationPolicy();
        p.setThreshold(this.casProperties.getAuthn().getX509().getRevocationPolicyThreshold());
        return p;
    }

    @Bean
    public RevocationPolicy denyRevocationPolicy() {
        return new DenyRevocationPolicy();
    }

    @Bean
    public RevocationChecker crlDistributionPointRevocationChecker() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        Cache cache = new Cache("CRL".concat(UUID.randomUUID().toString()), x509.getCacheMaxElementsInMemory(), x509.isCacheDiskOverflow(), x509.isCacheEternal(), x509.getCacheTimeToLiveSeconds(), x509.getCacheTimeToIdleSeconds());
        CRLDistributionPointRevocationChecker c = new CRLDistributionPointRevocationChecker(cache, this.getCrlFetcher());
        c.setCheckAll(this.casProperties.getAuthn().getX509().isCheckAll());
        c.setThrowOnFetchFailure(this.casProperties.getAuthn().getX509().isThrowOnFetchFailure());
        c.setExpiredCRLPolicy(X509AuthenticationConfiguration.getRevocationPolicy(x509.getCrlExpiredPolicy()));
        c.setUnavailableCRLPolicy(X509AuthenticationConfiguration.getRevocationPolicy(x509.getCrlUnavailablePolicy()));
        return c;
    }

    @Bean
    public RevocationChecker noOpRevocationChecker() {
        return new NoOpRevocationChecker();
    }

    @Bean
    public CRLFetcher resourceCrlFetcher() {
        return new ResourceCRLFetcher();
    }

    @Bean
    public RevocationChecker resourceCrlRevocationChecker() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        ResourceCRLRevocationChecker c = new ResourceCRLRevocationChecker();
        c.setRefreshInterval(x509.getRefreshIntervalSeconds());
        c.setCheckAll(x509.isCheckAll());
        c.setExpiredCRLPolicy(X509AuthenticationConfiguration.getRevocationPolicy(x509.getCrlResourceExpiredPolicy()));
        c.setUnavailableCRLPolicy(X509AuthenticationConfiguration.getRevocationPolicy(x509.getCrlResourceUnavailablePolicy()));
        Set<Resource> x509CrlResources = x509.getCrlResources().stream().map(s -> this.resourceLoader.getResource(s)).collect(Collectors.toSet());
        c.setResources(x509CrlResources);
        c.setFetcher(this.getCrlFetcher());
        return c;
    }

    private static RevocationPolicy getRevocationPolicy(String policy) {
        switch (policy.toLowerCase()) {
            case "allow": {
                return new AllowRevocationPolicy();
            }
            case "threshold": {
                return new ThresholdExpiredCRLRevocationPolicy();
            }
        }
        return new DenyRevocationPolicy();
    }

    private CRLFetcher getCrlFetcher() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        switch (x509.getCrlFetcher().toLowerCase()) {
            case "ldap": {
                return this.ldaptiveResourceCRLFetcher();
            }
        }
        return this.resourceCrlFetcher();
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler x509CredentialsAuthenticationHandler() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        X509CredentialsAuthenticationHandler h = new X509CredentialsAuthenticationHandler();
        h.setCheckKeyUsage(x509.isCheckKeyUsage());
        h.setMaxPathLength(x509.getMaxPathLength());
        h.setMaxPathLengthAllowUnspecified(x509.isMaxPathLengthAllowUnspecified());
        h.setRequireKeyUsage(x509.isRequireKeyUsage());
        switch (x509.getRevocationChecker().toLowerCase()) {
            case "resource": {
                h.setRevocationChecker(this.resourceCrlRevocationChecker());
                break;
            }
            case "crl": {
                h.setRevocationChecker(this.crlDistributionPointRevocationChecker());
                break;
            }
            default: {
                h.setRevocationChecker(this.noOpRevocationChecker());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)x509.getRegExTrustedIssuerDnPattern())) {
            h.setTrustedIssuerDnPattern(x509.getRegExTrustedIssuerDnPattern());
        }
        if (StringUtils.isNotBlank((CharSequence)x509.getRegExSubjectDnPattern())) {
            h.setTrustedIssuerDnPattern(x509.getRegExSubjectDnPattern());
        }
        h.setPrincipalFactory(this.x509PrincipalFactory());
        h.setServicesManager(this.servicesManager);
        h.setName(x509.getName());
        return h;
    }

    @Bean
    public CRLFetcher ldaptiveResourceCRLFetcher() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        LdaptiveResourceCRLFetcher r = new LdaptiveResourceCRLFetcher();
        r.setConnectionConfig(Beans.newConnectionConfig((AbstractLdapProperties)x509.getLdap()));
        r.setSearchExecutor(Beans.newSearchExecutor((String)x509.getLdap().getBaseDn(), (String)x509.getLdap().getSearchFilter()));
        return r;
    }

    @Bean
    @RefreshScope
    public PrincipalResolver x509SubjectPrincipalResolver() {
        X509SubjectPrincipalResolver r = new X509SubjectPrincipalResolver();
        r.setDescriptor(this.casProperties.getAuthn().getX509().getPrincipalDescriptor());
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getX509().getPrincipal().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getX509().getPrincipal().isReturnNull());
        r.setPrincipalFactory(this.x509PrincipalFactory());
        return r;
    }

    @Bean
    @RefreshScope
    public PrincipalResolver x509SubjectDNPrincipalResolver() {
        X509SubjectDNPrincipalResolver r = new X509SubjectDNPrincipalResolver();
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getX509().getPrincipal().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getX509().getPrincipal().isReturnNull());
        r.setPrincipalFactory(this.x509PrincipalFactory());
        return r;
    }

    @Bean
    @RefreshScope
    public PrincipalResolver x509SubjectAlternativeNameUPNPrincipalResolver() {
        X509SubjectAlternativeNameUPNPrincipalResolver r = new X509SubjectAlternativeNameUPNPrincipalResolver();
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getX509().getPrincipal().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getX509().getPrincipal().isReturnNull());
        r.setPrincipalFactory(this.x509PrincipalFactory());
        return r;
    }

    @Bean
    @RefreshScope
    public PrincipalResolver x509SerialNumberPrincipalResolver() {
        X509SerialNumberPrincipalResolver r = new X509SerialNumberPrincipalResolver();
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getX509().getPrincipal().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getX509().getPrincipal().isReturnNull());
        r.setPrincipalFactory(this.x509PrincipalFactory());
        return r;
    }

    @Bean
    public PrincipalFactory x509PrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public PrincipalResolver x509SerialNumberAndIssuerDNPrincipalResolver() {
        X509SerialNumberAndIssuerDNPrincipalResolver r = new X509SerialNumberAndIssuerDNPrincipalResolver();
        r.setSerialNumberPrefix(this.casProperties.getAuthn().getX509().getSerialNumberPrefix());
        r.setValueDelimiter(this.casProperties.getAuthn().getX509().getValueDelimiter());
        return r;
    }

    @PostConstruct
    public void initializeAuthenticationHandler() {
        PrincipalResolver resolver = this.personDirectoryPrincipalResolver;
        if (this.casProperties.getAuthn().getX509().getPrincipalType() != null) {
            switch (this.casProperties.getAuthn().getX509().getPrincipalType()) {
                case SERIAL_NO: {
                    resolver = this.x509SerialNumberPrincipalResolver();
                    break;
                }
                case SERIAL_NO_DN: {
                    resolver = this.x509SerialNumberAndIssuerDNPrincipalResolver();
                    break;
                }
                case SUBJECT: {
                    resolver = this.x509SubjectPrincipalResolver();
                    break;
                }
                case SUBJECT_ALT_NAME: {
                    resolver = this.x509SubjectAlternativeNameUPNPrincipalResolver();
                    break;
                }
                default: {
                    resolver = this.x509SubjectDNPrincipalResolver();
                }
            }
        }
        this.authenticationHandlersResolvers.put(this.x509CredentialsAuthenticationHandler(), resolver);
    }
}

