/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.util.DateTimeUtils;
import org.cryptacular.util.CertUtil;
import org.springframework.core.io.InputStreamSource;

public final class CertUtils {
    public static final String X509_CERTIFICATE_TYPE = "X509";

    private CertUtils() {
    }

    public static boolean isExpired(X509CRL crl) {
        return CertUtils.isExpired(crl, ZonedDateTime.now(ZoneOffset.UTC));
    }

    public static boolean isExpired(X509CRL crl, ZonedDateTime reference) {
        return reference.isAfter(DateTimeUtils.zonedDateTimeOf((Date)crl.getNextUpdate()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate readCertificate(InputStreamSource resource) {
        try (InputStream in = resource.getInputStream();){
            X509Certificate x509Certificate = CertUtil.readCertificate((InputStream)in);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading certificate " + resource, e);
        }
    }

    public static String toString(X509Certificate cert) {
        return new ToStringBuilder((Object)cert, ToStringStyle.NO_CLASS_NAME_STYLE).append("subjectDn", (Object)cert.getSubjectDN()).append("serialNumber", (Object)cert.getSerialNumber()).build();
    }

    public static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("X509 certificate type not supported by default provider.", e);
        }
    }
}

