/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.adaptors.x509.util.CertUtils;
import org.apereo.cas.util.EncodingUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;

public class X509CertificateCredentialJsonDeserializer
extends JsonDeserializer<X509CertificateCredential> {
    public X509CertificateCredential deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        ArrayList certs = new ArrayList();
        node.findValues("certificates").forEach(n -> {
            String cert = n.get(0).textValue();
            byte[] data = EncodingUtils.decodeBase64((String)cert);
            certs.add(CertUtils.readCertificate((InputStreamSource)new InputStreamResource((InputStream)new ByteArrayInputStream(data))));
        });
        X509CertificateCredential c = new X509CertificateCredential(certs.toArray(new X509Certificate[0]));
        return c;
    }
}

