/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Arrays;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.jooq.lambda.Unchecked;

public class X509CertificateCredentialJsonSerializer
extends JsonSerializer<X509CertificateCredential> {
    public void serialize(X509CertificateCredential value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeArrayFieldStart("certificates");
        Arrays.stream(value.getCertificates()).forEach(Unchecked.consumer(c -> generator.writeBinary(c.getEncoded())));
        generator.writeEndArray();
    }

    public void serializeWithType(X509CertificateCredential value, JsonGenerator generator, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        try {
            typeSer.writeTypePrefixForObject((Object)value, generator);
            this.serialize(value, generator, serializers);
            typeSer.writeTypeSuffixForObject((Object)value, generator);
        }
        catch (Exception e) {
            throw new JsonMappingException("Unable to serialize X509 certificate", (Throwable)e);
        }
    }

    public Class<X509CertificateCredential> handledType() {
        return X509CertificateCredential.class;
    }
}

