/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.adaptors.x509.BaseX509Tests;
import org.apereo.cas.adaptors.x509.authentication.X509CertificateExtractor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="X509")
@SpringBootTest(classes={BaseX509Tests.SharedTestConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RequestHeaderX509CertificateExtractorTests {
    @Autowired
    @Qualifier(value="x509CertificateExtractor")
    private X509CertificateExtractor x509CertificateExtractor;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Test
    public void verifyNullHeader() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader(this.casProperties.getAuthn().getX509().getSslHeaderName(), (Object)"(null)");
        Assertions.assertNull((Object)this.x509CertificateExtractor.extract((HttpServletRequest)request));
    }

    @Test
    public void verifyBadHeaderLength() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader(this.casProperties.getAuthn().getX509().getSslHeaderName(), (Object)"header-value");
        Assertions.assertNull((Object)this.x509CertificateExtractor.extract((HttpServletRequest)request));
    }

    @Test
    public void verifyBadHeader() {
        String cert = "-----BEGIN CERTIFICATE-----\nwhatever\n-----END CERTIFICATE-----";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader(this.casProperties.getAuthn().getX509().getSslHeaderName(), (Object)"-----BEGIN CERTIFICATE-----\nwhatever\n-----END CERTIFICATE-----");
        Assertions.assertNull((Object)this.x509CertificateExtractor.extract((HttpServletRequest)request));
    }
}

