/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509;

import java.security.cert.X509Certificate;
import java.util.Map;
import org.apereo.cas.adaptors.x509.BaseX509Tests;
import org.apereo.cas.adaptors.x509.authentication.CasX509Certificate;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationTransaction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={BaseX509Tests.SharedTestConfiguration.class}, properties={"cas.authn.x509.principal-type=SUBJECT_DN", "cas.authn.attribute-repository.groovy[0].location=classpath:/GroovyAttributeDao.groovy", "cas.authn.attribute-repository.groovy[0].order=1", "cas.authn.attribute-repository.merger=multivalued"})
@Tag(value="X509")
public class X509SubjectDNPrincipalResolverAggregateTests {
    private static final CasX509Certificate VALID_CERTIFICATE = new CasX509Certificate(true);
    @Autowired
    @Qualifier(value="casAuthenticationManager")
    private AuthenticationManager authenticationManager;

    @Test
    public void verifyResolverAsAggregate() {
        X509CertificateCredential c = new X509CertificateCredential(new X509Certificate[]{VALID_CERTIFICATE});
        c.setCertificate((X509Certificate)VALID_CERTIFICATE);
        Authentication result = this.authenticationManager.authenticate((AuthenticationTransaction)DefaultAuthenticationTransaction.of((Credential[])new Credential[]{c}));
        Assertions.assertNotNull((Object)result);
        Map attributes = result.getPrincipal().getAttributes();
        Assertions.assertTrue((boolean)attributes.containsKey("subjectX500Principal"));
        Assertions.assertTrue((boolean)attributes.containsKey("groovySubjectX500Principal"));
    }
}

