/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.config;

import java.net.URI;
import java.time.Duration;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.handler.support.X509CredentialsAuthenticationHandler;
import org.apereo.cas.adaptors.x509.authentication.ldap.LdaptiveResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.principal.DefaultX509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.EDIPIX509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CommonNameEDIPIPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SerialNumberAndIssuerDNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SerialNumberPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectAlternativeNameRFC822EmailPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectAlternativeNameUPNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectDNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.CRLDistributionPointRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.NoOpRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.ResourceCRLRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.RevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.AllowRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.DenyRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.ThresholdExpiredCRLRevocationPolicy;
import org.apereo.cas.adaptors.x509.util.X509AuthenticationUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.x509.CnEdipiPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.Rfc822EmailPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SerialNoDnPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SerialNoPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SubjectAltNamePrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SubjectDnPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.X509Properties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.model.Capacity;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.ehcache.UserManagedCache;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration(value="x509AuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class X509AuthenticationConfiguration {
    private static final int HEX = 16;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"allowRevocationPolicy"})
    public RevocationPolicy allowRevocationPolicy() {
        return new AllowRevocationPolicy();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"thresholdExpiredCRLRevocationPolicy"})
    public RevocationPolicy thresholdExpiredCRLRevocationPolicy() {
        return new ThresholdExpiredCRLRevocationPolicy(this.casProperties.getAuthn().getX509().getRevocationPolicyThreshold());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"denyRevocationPolicy"})
    public RevocationPolicy denyRevocationPolicy() {
        return new DenyRevocationPolicy();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"crlDistributionPointRevocationChecker"})
    public RevocationChecker crlDistributionPointRevocationChecker() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        UserManagedCacheBuilder builder = UserManagedCacheBuilder.newUserManagedCacheBuilder(URI.class, byte[].class);
        if (x509.isCacheDiskOverflow()) {
            Capacity capacity = Capacity.parse((String)x509.getCacheDiskSize());
            builder = builder.withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().disk(capacity.getSize().longValue(), MemoryUnit.valueOf((String)capacity.getUnitOfMeasure().name()), false));
        }
        builder = builder.withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)x509.getCacheMaxElementsInMemory(), (ResourceUnit)EntryUnit.ENTRIES));
        builder = x509.isCacheEternal() ? builder.withExpiry(ExpiryPolicyBuilder.noExpiration()) : builder.withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(x509.getCacheTimeToLiveSeconds())));
        UserManagedCache cache = builder.build(true);
        return new CRLDistributionPointRevocationChecker(x509.isCheckAll(), this.getRevocationPolicy(x509.getCrlUnavailablePolicy()), this.getRevocationPolicy(x509.getCrlExpiredPolicy()), cache, this.crlFetcher(), x509.isThrowOnFetchFailure());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"noOpRevocationChecker"})
    public RevocationChecker noOpRevocationChecker() {
        return new NoOpRevocationChecker();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"resourceCrlRevocationChecker"})
    public RevocationChecker resourceCrlRevocationChecker() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        Set x509CrlResources = x509.getCrlResources().stream().map(s -> this.resourceLoader.getResource(s)).collect(Collectors.toSet());
        return new ResourceCRLRevocationChecker(x509.isCheckAll(), this.getRevocationPolicy(x509.getCrlResourceUnavailablePolicy()), this.getRevocationPolicy(x509.getCrlResourceExpiredPolicy()), x509.getRefreshIntervalSeconds(), this.crlFetcher(), x509CrlResources);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"crlFetcher"})
    public CRLFetcher crlFetcher() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        switch (x509.getCrlFetcher().toLowerCase()) {
            case "ldap": {
                return new LdaptiveResourceCRLFetcher(LdapUtils.newLdaptiveConnectionConfig((AbstractLdapProperties)x509.getLdap()), LdapUtils.newLdaptiveSearchOperation((String)x509.getLdap().getBaseDn(), (String)x509.getLdap().getSearchFilter()), x509.getLdap().getCertificateAttribute());
            }
        }
        return new ResourceCRLFetcher();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509CredentialsAuthenticationHandler"})
    public AuthenticationHandler x509CredentialsAuthenticationHandler() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        RevocationChecker revChecker = this.getRevocationCheckerFrom(x509);
        Pattern subjectDnPattern = StringUtils.isNotBlank((CharSequence)x509.getRegExSubjectDnPattern()) ? RegexUtils.createPattern((String)x509.getRegExSubjectDnPattern()) : null;
        Pattern trustedIssuerDnPattern = StringUtils.isNotBlank((CharSequence)x509.getRegExTrustedIssuerDnPattern()) ? RegexUtils.createPattern((String)x509.getRegExTrustedIssuerDnPattern()) : null;
        return new X509CredentialsAuthenticationHandler(x509.getName(), (ServicesManager)this.servicesManager.getObject(), this.x509PrincipalFactory(), trustedIssuerDnPattern, x509.getMaxPathLength(), x509.isMaxPathLengthAllowUnspecified(), x509.isCheckKeyUsage(), x509.isRequireKeyUsage(), subjectDnPattern, revChecker, Integer.valueOf(x509.getOrder()));
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509SubjectPrincipalResolver"})
    public PrincipalResolver x509SubjectPrincipalResolver() {
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectPrincipalResolver resolver = (X509SubjectPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setPrincipalDescriptor(x509.getPrincipalDescriptor());
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        return resolver;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509SubjectDNPrincipalResolver"})
    public PrincipalResolver x509SubjectDNPrincipalResolver() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        SubjectDnPrincipalResolverProperties subjectDn = x509.getSubjectDn();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectDNPrincipalResolver resolver = (X509SubjectDNPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectDNPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setSubjectDnFormat(X509AuthenticationUtils.getSubjectDnFormat((SubjectDnPrincipalResolverProperties.SubjectDnFormat)subjectDn.getFormat()));
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        return resolver;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509SubjectAlternativeNameUPNPrincipalResolver"})
    public PrincipalResolver x509SubjectAlternativeNameUPNPrincipalResolver() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        SubjectAltNamePrincipalResolverProperties subjectAltNameProperties = x509.getSubjectAltName();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectAlternativeNameUPNPrincipalResolver resolver = (X509SubjectAlternativeNameUPNPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectAlternativeNameUPNPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setAlternatePrincipalAttribute(subjectAltNameProperties.getAlternatePrincipalAttribute());
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        return resolver;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509SubjectAlternativeNameRFC822EmailPrincipalResolver"})
    public PrincipalResolver x509SubjectAlternativeNameRFC822EmailPrincipalResolver() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        Rfc822EmailPrincipalResolverProperties rfc822EmailProperties = x509.getRfc822Email();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectAlternativeNameRFC822EmailPrincipalResolver resolver = (X509SubjectAlternativeNameRFC822EmailPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectAlternativeNameRFC822EmailPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setAlternatePrincipalAttribute(rfc822EmailProperties.getAlternatePrincipalAttribute());
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        return resolver;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509SerialNumberPrincipalResolver"})
    public PrincipalResolver x509SerialNumberPrincipalResolver() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        return this.getX509SerialNumberPrincipalResolver(x509);
    }

    @ConditionalOnMissingBean(name={"x509PrincipalFactory"})
    @Bean
    public PrincipalFactory x509PrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509SerialNumberAndIssuerDNPrincipalResolver"})
    public PrincipalResolver x509SerialNumberAndIssuerDNPrincipalResolver() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        SerialNoDnPrincipalResolverProperties serialNoDnProperties = x509.getSerialNoDn();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        X509SerialNumberAndIssuerDNPrincipalResolver resolver = (X509SerialNumberAndIssuerDNPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SerialNumberAndIssuerDNPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setSerialNumberPrefix(serialNoDnProperties.getSerialNumberPrefix());
        resolver.setValueDelimiter(serialNoDnProperties.getValueDelimiter());
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        return resolver;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"x509CommonNameEDIPIPrincipalResolver"})
    public PrincipalResolver x509CommonNameEDIPIPrincipalResolver() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        CnEdipiPrincipalResolverProperties cnEdipiProperties = x509.getCnEdipi();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        X509CommonNameEDIPIPrincipalResolver resolver = (X509CommonNameEDIPIPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509CommonNameEDIPIPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setAlternatePrincipalAttribute(cnEdipiProperties.getAlternatePrincipalAttribute());
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        return resolver;
    }

    @ConditionalOnMissingBean(name={"x509AuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer x509AuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.x509CredentialsAuthenticationHandler(), this.getPrincipalResolver());
    }

    @ConditionalOnMissingBean(name={"x509AttributeExtractor"})
    @RefreshScope
    @Bean
    public X509AttributeExtractor x509AttributeExtractor() {
        X509Properties x509 = this.casProperties.getAuthn().getX509();
        if (x509.getCnEdipi().isExtractEdipiAsAttribute()) {
            return new EDIPIX509AttributeExtractor();
        }
        return new DefaultX509AttributeExtractor();
    }

    private PrincipalResolver getPrincipalResolver() {
        X509Properties.PrincipalTypes type = this.casProperties.getAuthn().getX509().getPrincipalType();
        if (type == X509Properties.PrincipalTypes.SERIAL_NO) {
            return this.x509SerialNumberPrincipalResolver();
        }
        if (type == X509Properties.PrincipalTypes.SERIAL_NO_DN) {
            return this.x509SerialNumberAndIssuerDNPrincipalResolver();
        }
        if (type == X509Properties.PrincipalTypes.SUBJECT) {
            return this.x509SubjectPrincipalResolver();
        }
        if (type == X509Properties.PrincipalTypes.SUBJECT_ALT_NAME) {
            return this.x509SubjectAlternativeNameUPNPrincipalResolver();
        }
        if (type == X509Properties.PrincipalTypes.RFC822_EMAIL) {
            return this.x509SubjectAlternativeNameRFC822EmailPrincipalResolver();
        }
        if (type == X509Properties.PrincipalTypes.CN_EDIPI) {
            return this.x509CommonNameEDIPIPrincipalResolver();
        }
        return this.x509SubjectDNPrincipalResolver();
    }

    private X509SerialNumberPrincipalResolver getX509SerialNumberPrincipalResolver(X509Properties x509) {
        SerialNoPrincipalResolverProperties serialNoProperties = x509.getSerialNo();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        int radix = serialNoProperties.getPrincipalSNRadix();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SerialNumberPrincipalResolver resolver = (X509SerialNumberPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.x509PrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SerialNumberPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setX509AttributeExtractor(this.x509AttributeExtractor());
        if (2 <= radix && radix <= 36) {
            if (radix == 16) {
                resolver.setRadix(radix);
                resolver.setZeroPadding(serialNoProperties.isPrincipalHexSNZeroPadding());
                return resolver;
            }
            resolver.setRadix(radix);
            return resolver;
        }
        return resolver;
    }

    private RevocationChecker getRevocationCheckerFrom(X509Properties x509) {
        String checker = x509.getRevocationChecker().trim();
        if ("resource".equalsIgnoreCase(checker)) {
            return this.resourceCrlRevocationChecker();
        }
        if ("crl".equalsIgnoreCase(checker)) {
            return this.crlDistributionPointRevocationChecker();
        }
        return this.noOpRevocationChecker();
    }

    private RevocationPolicy getRevocationPolicy(String policy) {
        switch (policy.trim().toLowerCase()) {
            case "allow": {
                return this.allowRevocationPolicy();
            }
            case "threshold": {
                return this.thresholdExpiredCRLRevocationPolicy();
            }
        }
        return this.denyRevocationPolicy();
    }
}

