/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.yubikey.dao;

import com.yubico.client.v2.YubicoClient;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccount;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountValidator;
import org.apereo.cas.adaptors.yubikey.registry.BaseYubiKeyAccountRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="transactionManagerYubiKey", readOnly=false)
public class JpaYubiKeyAccountRegistry
extends BaseYubiKeyAccountRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaYubiKeyAccountRegistry.class);
    private static final String SELECT_QUERY = "SELECT r from YubiKeyAccount r ";
    @PersistenceContext(unitName="yubiKeyEntityManagerFactory")
    private EntityManager entityManager;

    public JpaYubiKeyAccountRegistry(YubiKeyAccountValidator accountValidator) {
        super(accountValidator);
    }

    public boolean isYubiKeyRegisteredFor(String uid) {
        try {
            return this.entityManager.createQuery(SELECT_QUERY.concat("where r.username = :username"), YubiKeyAccount.class).setParameter("username", (Object)uid).getSingleResult() != null;
        }
        catch (NoResultException e) {
            LOGGER.debug("No registration record could be found for id [{}]", (Object)uid);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean isYubiKeyRegisteredFor(String uid, String yubikeyPublicId) {
        try {
            return this.entityManager.createQuery(SELECT_QUERY.concat("where r.username = :username and r.publicId = :publicId"), YubiKeyAccount.class).setParameter("username", (Object)uid).setParameter("publicId", (Object)yubikeyPublicId).getSingleResult() != null;
        }
        catch (NoResultException e) {
            LOGGER.debug("No registration record could be found for id [{}] and public id [{}]", (Object)uid, (Object)yubikeyPublicId);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean registerAccountFor(String uid, String token) {
        if (this.accountValidator.isValid(uid, token)) {
            String yubikeyPublicId = YubicoClient.getPublicId((String)token);
            YubiKeyAccount account = new YubiKeyAccount();
            account.setPublicId(yubikeyPublicId);
            account.setUsername(uid);
            return this.entityManager.merge((Object)account) != null;
        }
        return false;
    }
}

