/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccount;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountRegistry;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountValidator;
import org.apereo.cas.adaptors.yubikey.dao.JpaYubiKeyAccountRegistry;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="jpaYubiKeyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class JpaYubiKeyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaYubiKeyConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="yubiKeyAccountValidator")
    private YubiKeyAccountValidator yubiKeyAccountValidator;

    @RefreshScope
    @Bean
    public HibernateJpaVendorAdapter jpaYubiKeyVendorAdapter() {
        return JpaBeans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc());
    }

    @Bean
    public DataSource dataSourceYubiKey() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getMfa().getYubikey().getJpa());
    }

    public List<String> jpaYubiKeyPackagesToScan() {
        return CollectionUtils.wrapList((Object[])new String[]{YubiKeyAccount.class.getPackage().getName()});
    }

    @Autowired
    @Bean
    public PlatformTransactionManager transactionManagerYubiKey(@Qualifier(value="yubiKeyEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean yubiKeyEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean bean = JpaBeans.newHibernateEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)this.jpaYubiKeyVendorAdapter(), "jpaYubiKeyRegistryContext", this.jpaYubiKeyPackagesToScan(), this.dataSourceYubiKey()), (AbstractJpaProperties)this.casProperties.getAuthn().getMfa().getYubikey().getJpa());
        return bean;
    }

    @Bean
    public YubiKeyAccountRegistry yubiKeyAccountRegistry() {
        return new JpaYubiKeyAccountRegistry(this.yubiKeyAccountValidator);
    }
}

