/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.adaptors.yubikey.JpaYubiKeyAccount;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountRegistry;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountValidator;
import org.apereo.cas.adaptors.yubikey.dao.JpaYubiKeyAccountRegistry;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="jpaYubiKeyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class JpaYubiKeyConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="yubiKeyAccountValidator")
    private ObjectProvider<YubiKeyAccountValidator> yubiKeyAccountValidator;
    @Autowired
    @Qualifier(value="yubikeyAccountCipherExecutor")
    private ObjectProvider<CipherExecutor> yubikeyAccountCipherExecutor;
    @Autowired
    @Qualifier(value="jpaBeanFactory")
    private ObjectProvider<JpaBeanFactory> jpaBeanFactory;

    @RefreshScope
    @Bean
    public JpaVendorAdapter jpaYubiKeyVendorAdapter() {
        return ((JpaBeanFactory)this.jpaBeanFactory.getObject()).newJpaVendorAdapter(this.casProperties.getJdbc());
    }

    @Bean
    @ConditionalOnMissingBean(name={"dataSourceYubiKey"})
    @RefreshScope
    public DataSource dataSourceYubiKey() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getMfa().getYubikey().getJpa());
    }

    @Bean
    public List<String> jpaYubiKeyPackagesToScan() {
        return CollectionUtils.wrapList((Object[])new String[]{JpaYubiKeyAccount.class.getPackage().getName()});
    }

    @Autowired
    @Bean
    public PlatformTransactionManager transactionManagerYubiKey(@Qualifier(value="yubiKeyEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean yubiKeyEntityManagerFactory() {
        JpaBeanFactory factory = (JpaBeanFactory)this.jpaBeanFactory.getObject();
        JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(this.dataSourceYubiKey()).packagesToScan(this.jpaYubiKeyPackagesToScan()).persistenceUnitName("jpaYubiKeyRegistryContext").jpaVendorAdapter(this.jpaYubiKeyVendorAdapter()).build();
        return factory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)this.casProperties.getAuthn().getMfa().getYubikey().getJpa());
    }

    @Bean
    public YubiKeyAccountRegistry yubiKeyAccountRegistry() {
        JpaYubiKeyAccountRegistry registry = new JpaYubiKeyAccountRegistry((YubiKeyAccountValidator)this.yubiKeyAccountValidator.getObject());
        registry.setCipherExecutor((CipherExecutor)this.yubikeyAccountCipherExecutor.getObject());
        return registry;
    }
}

