/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.adaptors.yubikey.JpaYubiKeyAccount;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountRegistry;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountValidator;
import org.apereo.cas.adaptors.yubikey.dao.JpaYubiKeyAccountRegistry;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.BeanContainer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
@Configuration(value="JpaYubiKeyConfiguration", proxyBeanMethods=false)
public class JpaYubiKeyConfiguration {

    @Configuration(value="JpaYubiKeyDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaYubiKeyDataConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceYubiKey"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceYubiKey(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAuthn().getMfa().getYubikey().getJpa());
        }
    }

    @Configuration(value="JpaYubiKeyRegistryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaYubiKeyRegistryConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public YubiKeyAccountRegistry yubiKeyAccountRegistry(@Qualifier(value="yubiKeyAccountValidator") YubiKeyAccountValidator yubiKeyAccountValidator, @Qualifier(value="yubikeyAccountCipherExecutor") CipherExecutor yubikeyAccountCipherExecutor) {
            JpaYubiKeyAccountRegistry registry = new JpaYubiKeyAccountRegistry(yubiKeyAccountValidator);
            registry.setCipherExecutor(yubikeyAccountCipherExecutor);
            return registry;
        }
    }

    @Configuration(value="JpaYubiKeyTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaYubiKeyTransactionConfiguration {
        @Bean
        public PlatformTransactionManager transactionManagerYubiKey(@Qualifier(value="yubiKeyEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }
    }

    @Configuration(value="JpaYubiKeyEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaYubiKeyEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaYubiKeyVendorAdapter(CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        public BeanContainer<String> jpaYubiKeyPackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JpaYubiKeyAccount.class.getPackage().getName()));
        }

        @Bean
        public LocalContainerEntityManagerFactoryBean yubiKeyEntityManagerFactory(CasConfigurationProperties casProperties, @Qualifier(value="dataSourceYubiKey") DataSource dataSourceYubiKey, @Qualifier(value="jpaYubiKeyPackagesToScan") BeanContainer<String> jpaYubiKeyPackagesToScan, @Qualifier(value="jpaYubiKeyVendorAdapter") JpaVendorAdapter jpaYubiKeyVendorAdapter, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(dataSourceYubiKey).packagesToScan(jpaYubiKeyPackagesToScan.toSet()).persistenceUnitName("jpaYubiKeyRegistryContext").jpaVendorAdapter(jpaYubiKeyVendorAdapter).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getAuthn().getMfa().getYubikey().getJpa());
        }
    }
}

