/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.yubikey.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.adaptors.yubikey.JpaYubiKeyAccount;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccount;
import org.apereo.cas.adaptors.yubikey.YubiKeyAccountValidator;
import org.apereo.cas.adaptors.yubikey.YubiKeyDeviceRegistrationRequest;
import org.apereo.cas.adaptors.yubikey.YubiKeyRegisteredDevice;
import org.apereo.cas.adaptors.yubikey.registry.BaseYubiKeyAccountRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=false)
@Transactional(transactionManager="transactionManagerYubiKey")
public class JpaYubiKeyAccountRegistry
extends BaseYubiKeyAccountRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaYubiKeyAccountRegistry.class);
    private static final String SELECT_QUERY = "SELECT r from " + JpaYubiKeyAccount.class.getSimpleName() + " r ";
    private static final String SELECT_ACCOUNT_QUERY = SELECT_QUERY.concat(" WHERE r.username = :username");
    @PersistenceContext(unitName="jpaYubiKeyRegistryContext")
    private EntityManager entityManager;

    public JpaYubiKeyAccountRegistry(YubiKeyAccountValidator accountValidator) {
        super(accountValidator);
    }

    public Collection<? extends YubiKeyAccount> getAccountsInternal() {
        return this.entityManager.createQuery(SELECT_QUERY, JpaYubiKeyAccount.class).getResultList();
    }

    public YubiKeyAccount getAccountInternal(String uid) {
        try {
            JpaYubiKeyAccount account = this.fetchSingleYubiKeyAccount(uid);
            this.entityManager.detach((Object)account);
            return account;
        }
        catch (NoResultException e) {
            LOGGER.debug("No registration record could be found", (Throwable)e);
            return null;
        }
    }

    public void delete(String uid) {
        JpaYubiKeyAccount account = this.fetchSingleYubiKeyAccount(uid);
        this.entityManager.remove((Object)account);
        LOGGER.debug("Deleted [{}] record(s)", (Object)account);
    }

    public void delete(String username, long deviceId) {
        try {
            JpaYubiKeyAccount account = this.fetchSingleYubiKeyAccount(username);
            if (account != null && account.getDevices().removeIf(device -> deviceId == device.getId())) {
                this.entityManager.merge((Object)account);
            }
        }
        catch (NoResultException e) {
            LOGGER.debug("No registration record could be found", (Throwable)e);
        }
    }

    public void deleteAll() {
        this.entityManager.createQuery(SELECT_QUERY).getResultList().forEach(r -> this.entityManager.remove(r));
    }

    public YubiKeyAccount save(YubiKeyDeviceRegistrationRequest request, YubiKeyRegisteredDevice ... device) {
        YubiKeyAccount jpaAccount = ((JpaYubiKeyAccount.JpaYubiKeyAccountBuilder)((JpaYubiKeyAccount.JpaYubiKeyAccountBuilder)JpaYubiKeyAccount.builder().username(request.getUsername())).devices(CollectionUtils.wrapList((Object[])device))).build();
        return (YubiKeyAccount)this.entityManager.merge((Object)jpaAccount);
    }

    public YubiKeyAccount save(YubiKeyAccount account) {
        YubiKeyAccount jpaAccount = ((JpaYubiKeyAccount.JpaYubiKeyAccountBuilder)((JpaYubiKeyAccount.JpaYubiKeyAccountBuilder)JpaYubiKeyAccount.builder().username(account.getUsername())).devices(account.getDevices())).build();
        return (YubiKeyAccount)this.entityManager.merge((Object)jpaAccount);
    }

    public boolean update(YubiKeyAccount account) {
        return this.entityManager.merge((Object)account) != null;
    }

    private JpaYubiKeyAccount fetchSingleYubiKeyAccount(String username) {
        return (JpaYubiKeyAccount)((Object)this.entityManager.createQuery(SELECT_ACCOUNT_QUERY, JpaYubiKeyAccount.class).setParameter("username", (Object)username).getSingleResult());
    }
}

