/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.audit.spi.config.CasCoreAuditConfiguration;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasFiltersConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.CasPropertiesConfiguration;
import org.apereo.cas.config.CasWebAppConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.config.support.authentication.AcceptUsersAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logging.config.CasLoggingConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.validation.config.CasCoreValidationConfiguration;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.mvc.Controller;

@SpringBootTest(classes={CasFiltersConfiguration.class, CasPropertiesConfiguration.class, CasWebAppConfiguration.class, CasCoreWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, AcceptUsersAuthenticationEventExecutionPlanConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreHttpConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasThemesConfiguration.class, CasCoreNotificationsConfiguration.class, CasLoggingConfiguration.class, CasCoreServicesConfiguration.class, CasCoreUtilConfiguration.class, CasCoreLogoutConfiguration.class, CasCookieConfiguration.class, CasCoreWebConfiguration.class, CasCoreValidationConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasCoreConfiguration.class, CasCoreAuditConfiguration.class, CasPersonDirectoryConfiguration.class, WebMvcAutoConfiguration.class, AopAutoConfiguration.class, MailSenderAutoConfiguration.class, RefreshAutoConfiguration.class}, properties={"spring.main.allow-bean-definition-overriding=true", "cas.authn.accept.users=casuser::Mellon", "cas.http-web-request.cors.enabled=true", "cas.http-web-request.pattern-to-block=.*", "cas.http-web-request.header.content-security-policy=policy"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@WebAppConfiguration
@EnableAspectJAutoProxy(proxyTargetClass=false)
@EnableWebMvc
@Tag(value="WebApp")
public class WiringConfigurationTests {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="rootController")
    private Controller rootController;
    @Autowired
    @Qualifier(value="localeResolver")
    private LocaleResolver localeResolver;
    @Autowired
    @Qualifier(value="currentCredentialsAndAuthenticationClearingFilter")
    private FilterRegistrationBean currentCredentialsAndAuthenticationClearingFilter;

    @Test
    public void verifyConfigurationClasses() {
        Assertions.assertNotNull((Object)this.applicationContext);
        Assertions.assertTrue((this.applicationContext.getBeanDefinitionCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyRootController() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("GET");
        request.setRequestURI("/cas/example");
        request.setQueryString("param=value");
        Assertions.assertNotNull((Object)this.rootController.handleRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
    }

    @Test
    public void verifyLocale() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setPreferredLocales(List.of(Locale.ENGLISH));
        Assertions.assertEquals((Object)Locale.ENGLISH, (Object)this.localeResolver.resolveLocale((HttpServletRequest)request));
        request = new MockHttpServletRequest();
        request.setPreferredLocales(List.of(Locale.ITALIAN));
        Assertions.assertEquals((Object)Locale.ITALIAN, (Object)this.localeResolver.resolveLocale((HttpServletRequest)request));
    }

    @Test
    public void verifyAuthFilterClearing() throws Exception {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)CoreAuthenticationTestUtils.getAuthentication());
        Filter filter = this.currentCredentialsAndAuthenticationClearingFilter.getFilter();
        filter.init((FilterConfig)new MockFilterConfig());
        filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        filter.destroy();
        Assertions.assertNull((Object)AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication());
        Assertions.assertNull((Object)AuthenticationCredentialsThreadLocalBinder.getCurrentAuthenticationBuilder());
        Assertions.assertNull((Object)AuthenticationCredentialsThreadLocalBinder.getCurrentCredentialIds());
        Assertions.assertNull((Object)AuthenticationCredentialsThreadLocalBinder.getCurrentCredentialIdsAsString());
        Assertions.assertNull((Object)AuthenticationCredentialsThreadLocalBinder.getInProgressAuthentication());
    }
}

