/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.security.BaseWebSecurityTests;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={WebTestConfiguration.class, BaseWebSecurityTests.SharedTestConfiguration.class}, properties={"server.port=8080", "spring.security.user.name=casuser", "spring.security.user.password=Mellon", "management.endpoints.enabled-by-default=true", "management.endpoints.web.exposure.include=*", "cas.monitor.endpoints.endpoint.beans.access=ANONYMOUS", "cas.monitor.endpoints.endpoint.info.access=DENY", "cas.monitor.endpoints.endpoint.env.access=AUTHENTICATED", "cas.monitor.endpoints.endpoint.health.access=IP_ADDRESS", "cas.monitor.endpoints.endpoint.health.required-ip-addresses[0]=196.+", "cas.monitor.endpoints.endpoint.health.required-ip-addresses[1]=10.0.0.0/24", "cas.monitor.endpoints.endpoint.health.required-ip-addresses[2]=172.16.0.0/16", "cas.monitor.endpoints.endpoint.health.required-ip-addresses[3]=200\\\\.0\\\\.0\\\\....", "cas.monitor.endpoints.form-login-enabled=true"}, webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="WebApp")
public class CasWebSecurityConfigurerAdapterWebTests {
    @Autowired
    private WebApplicationContext webApplicationContext;
    private MockMvc mvc;

    @BeforeEach
    public void setup() {
        this.mvc = ((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).apply(SecurityMockMvcConfigurers.springSecurity())).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN}).contentType(MediaType.APPLICATION_JSON))).build();
    }

    @Test
    public void verifyAccessToEndpoints() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/oidc/accessToken", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/oidc/accessToken", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/beans", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/info", (Object[])new Object[0]).with(SecurityMockMvcRequestPostProcessors.httpBasic((String)"casuser", (String)"Mellon"))).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/info", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/env", (Object[])new Object[0]).with(SecurityMockMvcRequestPostProcessors.httpBasic((String)"casuser", (String)"Mellon"))).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/health", (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"196.1.1.0"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/health", (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"10.0.0.9"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/health", (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"172.16.55.9"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/health", (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"200.0.0.123"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/health", (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"192.168.0.1"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/actuator/health", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @TestConfiguration(value="WebTestConfiguration", proxyBeanMethods=false)
    public static class WebTestConfiguration {

        @RestController(value="TestController")
        @RequestMapping(value={"/oidc/accessToken"})
        public class TestController {
            @GetMapping
            public ResponseEntity getMethod() {
                return ResponseEntity.ok().build();
            }

            @PostMapping
            public ResponseEntity postMethod() {
                return ResponseEntity.ok().build();
            }
        }
    }
}

