/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@SpringBootTest(classes={RefreshAutoConfiguration.class}, properties={"cas.monitor.endpoints.ldap.ldap-url=ldap://localhost:10389", "cas.monitor.endpoints.ldap.base-dn=ou=people,dc=example,dc=org", "cas.monitor.endpoints.ldap.search-filter=cn={user}", "cas.monitor.endpoints.ldap.bind-dn=cn=Directory Manager", "cas.monitor.endpoints.ldap.bind-credential=password"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public abstract class BaseEndpointLdapAuthenticationProviderTests {
    private static final int LDAP_PORT = 10389;
    @Autowired
    protected CasConfigurationProperties casProperties;

    @BeforeAll
    public static void bootstrap() {
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)new MockHttpServletRequest()));
        LDAPConnection localhost = new LDAPConnection("localhost", 10389, "cn=Directory Manager", "password");
        localhost.connect("localhost", 10389);
        localhost.bind("cn=Directory Manager", "password");
        LdapIntegrationTestsOperations.populateEntries((LDAPConnection)localhost, (InputStream)new ClassPathResource("ldif/ldap-authz.ldif").getInputStream(), (String)"ou=people,dc=example,dc=org");
    }

    @BeforeEach
    public void init() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
    }
}

