/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.apereo.cas.web.security.authentication.BaseEndpointLdapAuthenticationProviderTests;
import org.apereo.cas.web.security.authentication.EndpointLdapAuthenticationProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@EnabledIfListeningOnPort(port={10389})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Ldap")
public class EndpointLdapAuthenticationProviderDefaultRolesTests
extends BaseEndpointLdapAuthenticationProviderTests {
    @Test
    public void verifyAuthorizedByRole() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of("ROLE_888"));
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Assertions.assertThrows(InsufficientAuthenticationException.class, () -> provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", null)));
        Authentication token = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", (Object)"123456"));
        Assertions.assertNotNull((Object)token);
    }

    @Test
    public void verifyEmptyRoles() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of());
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Authentication token = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", (Object)"123456"));
        Assertions.assertNotNull((Object)token);
        Assertions.assertTrue((boolean)token.getAuthorities().isEmpty());
    }
}

