/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.apereo.cas.web.security.authentication.BaseEndpointLdapAuthenticationProviderTests;
import org.apereo.cas.web.security.authentication.EndpointLdapAuthenticationProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@EnabledIfListeningOnPort(port={10389})
@SpringBootTest(classes={RefreshAutoConfiguration.class}, properties={"cas.monitor.endpoints.ldap.ldap-authz.group-filter=businessCategory={user}", "cas.monitor.endpoints.ldap.ldap-authz.group-base-dn=ou=people,dc=example,dc=org", "cas.monitor.endpoints.ldap.ldap-authz.base-dn=ou=people,dc=example,dc=org", "cas.monitor.endpoints.ldap.ldap-authz.search-filter=cn={user}", "cas.monitor.endpoints.ldap.ldap-authz.group-attribute=roomNumber", "cas.monitor.endpoints.ldap.ldap-authz.group-prefix=ROLE_", "cas.monitor.endpoints.ldap.ldap-url=ldap://localhost:10389", "cas.monitor.endpoints.ldap.base-dn=ou=people,dc=example,dc=org", "cas.monitor.endpoints.ldap.search-filter=cn={user}", "cas.monitor.endpoints.ldap.bind-dn=cn=Directory Manager", "cas.monitor.endpoints.ldap.bind-credential=password"})
@Tag(value="Ldap")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class EndpointLdapAuthenticationProviderGroupsBasedTests
extends BaseEndpointLdapAuthenticationProviderTests {
    @Test
    public void verifyAuthorizedByGroup() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of("ROLE_888"));
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Assertions.assertNotNull((Object)provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", (Object)"123456")));
        Executable[] executableArray = new Executable[1];
        executableArray[0] = () -> ((EndpointLdapAuthenticationProvider)provider).destroy();
        Assertions.assertAll((Executable[])executableArray);
    }
}

