/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.apereo.cas.web.security.authentication.BaseEndpointLdapAuthenticationProviderTests;
import org.apereo.cas.web.security.authentication.EndpointLdapAuthenticationProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.monitor.endpoints.ldap.ldapAuthz.role-attribute=roomNumber", "cas.monitor.endpoints.ldap.ldap-authz.search-filter=cn={user}", "cas.monitor.endpoints.ldap.ldap-authz.base-dn=ou=people,dc=example,dc=org", "cas.monitor.endpoints.ldap.ldap-authz.role-prefix=ROLE_"})
@EnabledIfListeningOnPort(port={10389})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Ldap")
public class EndpointLdapAuthenticationProviderRolesBasedTests
extends BaseEndpointLdapAuthenticationProviderTests {
    @Test
    public void verifyAuthorizedByRole() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of("ROLE_888"));
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Assertions.assertTrue((boolean)provider.supports(UsernamePasswordAuthenticationToken.class));
        Authentication token = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", (Object)"123456"));
        Assertions.assertNotNull((Object)token);
        Executable[] executableArray = new Executable[1];
        executableArray[0] = () -> ((EndpointLdapAuthenticationProvider)provider).destroy();
        Assertions.assertAll((Executable[])executableArray);
    }

    @Test
    public void verifyUnauthorizedByRole() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of("SOME_BAD_ROLE"));
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Assertions.assertThrows(BadCredentialsException.class, () -> provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", (Object)"123456")));
        Executable[] executableArray = new Executable[1];
        executableArray[0] = () -> ((EndpointLdapAuthenticationProvider)provider).destroy();
        Assertions.assertAll((Executable[])executableArray);
    }

    @Test
    public void verifyUserNotFound() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of("SOME_BAD_ROLE"));
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Assertions.assertThrows(InsufficientAuthenticationException.class, () -> provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"UNKNOWN_USER", (Object)"123456")));
        Executable[] executableArray = new Executable[1];
        executableArray[0] = () -> ((EndpointLdapAuthenticationProvider)provider).destroy();
        Assertions.assertAll((Executable[])executableArray);
    }

    @Test
    public void verifyUserBadPassword() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.getUser().setRoles(List.of("SOME_BAD_ROLE"));
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
        EndpointLdapAuthenticationProvider provider = new EndpointLdapAuthenticationProvider(ldap, securityProperties, connectionFactory, authenticator);
        Assertions.assertThrows(BadCredentialsException.class, () -> provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"authzcas", (Object)"BAD_PASSWORD")));
        Executable[] executableArray = new Executable[1];
        executableArray[0] = () -> ((EndpointLdapAuthenticationProvider)provider).destroy();
        Assertions.assertAll((Executable[])executableArray);
    }
}

