/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webflow;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.audit.spi.config.CasCoreAuditConfiguration;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasFiltersConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.CasPropertiesConfiguration;
import org.apereo.cas.config.CasThymeleafConfiguration;
import org.apereo.cas.config.CasWebAppConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logging.config.CasLoggingConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.validation.config.CasCoreValidationConfiguration;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.config.CasSupportActionsConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={AopAutoConfiguration.class, RefreshAutoConfiguration.class, CasCoreWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasThemesConfiguration.class, CasThymeleafConfiguration.class, CasFiltersConfiguration.class, CasPropertiesConfiguration.class, CasWebAppConfiguration.class, TestWebflowContextConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreHttpConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasLoggingConfiguration.class, CasCoreServicesConfiguration.class, CasSupportActionsConfiguration.class, CasCoreUtilConfiguration.class, CasCoreLogoutConfiguration.class, CasCookieConfiguration.class, CasCoreWebConfiguration.class, CasCoreValidationConfiguration.class, CasCoreConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreAuditConfiguration.class, CasCoreNotificationsConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableAspectJAutoProxy(proxyTargetClass=false)
public abstract class BaseCasWebflowSessionContextConfigurationTests {
    protected static void assertResponseWrittenEquals(String response, MockRequestContext context) {
        MockHttpServletResponse nativeResponse = (MockHttpServletResponse)context.getExternalContext().getNativeResponse();
        try (InputStreamReader reader = new InputStreamReader(ResourceUtils.getResourceFrom((String)response).getInputStream(), StandardCharsets.UTF_8);){
            Assertions.assertEquals((Object)IOUtils.toString((Reader)reader), (Object)nativeResponse.getContentAsString());
        }
    }

    private static MockRequestContext getMockRequestContext() {
        MockRequestContext ctx = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockServletContext sCtx = new MockServletContext();
        ctx.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)sCtx, (HttpServletRequest)request, (HttpServletResponse)response));
        return ctx;
    }

    @Test
    public void verifyExecutorsAreBeans() {
        Assertions.assertNotNull((Object)this.getFlowExecutor());
    }

    @Test
    public void verifyFlowExecutorByClient() {
        MockRequestContext ctx = BaseCasWebflowSessionContextConfigurationTests.getMockRequestContext();
        LocalAttributeMap map = new LocalAttributeMap();
        this.getFlowExecutor().launchExecution("login", (MutableAttributeMap)map, ctx.getExternalContext());
    }

    public abstract FlowExecutor getFlowExecutor();

    @TestConfiguration(value="testWebflowContextConfiguration", proxyBeanMethods=false)
    public static class TestWebflowContextConfiguration {
        private static final String TEST = "test";
        @Autowired
        @Qualifier(value="principalElectionStrategy")
        private ObjectProvider<PrincipalElectionStrategy> principalElectionStrategy;

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action testWebflowSerialization() {
            return new AbstractAction(){

                protected Event doExecute(RequestContext requestContext) {
                    MutableAttributeMap flowScope = requestContext.getFlowScope();
                    flowScope.put(TestWebflowContextConfiguration.TEST, (Object)TestWebflowContextConfiguration.TEST);
                    flowScope.put("test0", Collections.singleton(TestWebflowContextConfiguration.TEST));
                    flowScope.put("test1", List.of(TestWebflowContextConfiguration.TEST));
                    flowScope.put("test2", Collections.singletonMap(TestWebflowContextConfiguration.TEST, TestWebflowContextConfiguration.TEST));
                    flowScope.put("test3", Arrays.asList(TestWebflowContextConfiguration.TEST, TestWebflowContextConfiguration.TEST));
                    flowScope.put("test4", new ConcurrentSkipListSet());
                    flowScope.put("test5", List.of("test1"));
                    flowScope.put("test6", Collections.unmodifiableSet(Collections.singleton(1)));
                    flowScope.put("test7", Collections.unmodifiableMap(new HashMap()));
                    flowScope.put("test8", Collections.emptyMap());
                    flowScope.put("test9", new TreeMap());
                    flowScope.put("test10", Collections.emptySet());
                    flowScope.put("test11", Collections.emptyList());
                    SimpleWebApplicationServiceImpl service = new SimpleWebApplicationServiceImpl();
                    service.setId("https://google.com");
                    service.setOriginalUrl("https://google.com");
                    service.setArtifactId(null);
                    Authentication authentication = CoreAuthenticationTestUtils.getAuthentication();
                    DefaultAuthenticationResultBuilder authenticationResultBuilder = new DefaultAuthenticationResultBuilder();
                    Principal principal = CoreAuthenticationTestUtils.getPrincipal();
                    authenticationResultBuilder.collect(authentication);
                    authenticationResultBuilder.collect((Credential)CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword());
                    AuthenticationResult authenticationResult = authenticationResultBuilder.build((PrincipalElectionStrategy)principalElectionStrategy.getObject(), (Service)service);
                    WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResultBuilder, (RequestContext)requestContext);
                    WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)requestContext);
                    WebUtils.putPrincipal((RequestContext)requestContext, (Principal)principal);
                    return this.success();
                }
            };
        }
    }
}

