/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;

@Plugin(name="AppenderRefFailoverPolicy", category="Core", elementType="appender", printObject=true)
public class AppenderRefFailoverPolicy
implements FailoverPolicy<String> {
    protected final AppenderRef appenderRef;
    private final Configuration configuration;
    protected AppenderControl appenderControl;

    protected AppenderRefFailoverPolicy(AppenderRef appenderRef, Configuration configuration) {
        this.appenderRef = appenderRef;
        this.configuration = configuration;
    }

    @Override
    public final void deliver(String failedPayload) {
        this.resolveAppender();
        this.doDeliver(failedPayload);
    }

    protected void doDeliver(String failedPayload) {
        this.appenderControl.callAppender(DefaultLogEventFactory.getInstance().createEvent(this.appenderRef.getRef(), null, this.getClass().getName(), this.appenderRef.getLevel(), (Message)new SimpleMessage(failedPayload), null, null));
    }

    private void resolveAppender() {
        if (this.appenderControl == null) {
            Appender appender = this.configuration.getAppender(this.appenderRef.getRef());
            if (appender == null) {
                throw new ConfigurationException("No failover appender named " + this.appenderRef.getRef() + " found");
            }
            this.appenderControl = new AppenderControl(appender, this.appenderRef.getLevel(), this.appenderRef.getFilter());
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<AppenderRefFailoverPolicy> {
        @PluginElement(value="AppenderRef")
        @Required(message="No appender specified for AppenderRefFailoverPolicy")
        private AppenderRef appenderRef;
        @PluginConfiguration
        private Configuration configuration;

        public AppenderRefFailoverPolicy build() {
            return new AppenderRefFailoverPolicy(this.appenderRef, this.configuration);
        }

        public Builder withAppenderRef(AppenderRef appenderRef) {
            this.appenderRef = appenderRef;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }
    }
}

