/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.NoopFailoverPolicy;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;

@Plugin(name="AsyncBatchDelivery", category="Core", elementType="batchDelivery", printObject=true)
public class AsyncBatchDelivery
implements BatchDelivery<String> {
    private static final Logger LOG = StatusLogger.getLogger();
    private final BatchOperations batchOperations;
    private final BatchEmitter batchEmitter;

    public AsyncBatchDelivery(int batchSize, int deliveryInterval, ClientObjectFactory objectFactory, FailoverPolicy failoverPolicy, IndexTemplate indexTemplate) {
        this.batchOperations = objectFactory.createBatchOperations();
        this.batchEmitter = this.createBatchEmitterServiceProvider().createInstance(batchSize, deliveryInterval, objectFactory, failoverPolicy);
        if (indexTemplate != null) {
            objectFactory.execute(indexTemplate);
        }
    }

    @Override
    public void add(String indexName, String log) {
        this.batchEmitter.add(this.batchOperations.createBatchItem(indexName, log));
    }

    @Override
    public void add(String indexName, ItemSource source) {
        this.batchEmitter.add(this.batchOperations.createBatchItem(indexName, source));
    }

    protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
        return new BatchEmitterServiceProvider();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<AsyncBatchDelivery> {
        public static final int DEFAULT_BATCH_SIZE = 1000;
        public static final int DEFAULT_DELIVERY_INTERVAL = 1000;
        public static final FailoverPolicy DEFAULT_FAILOVER_POLICY = new NoopFailoverPolicy();
        @PluginElement(value="elasticsearchClientFactory")
        @Required(message="No Elasticsearch client factory [JestHttp|ElasticsearchBulkProcessor] provided for AsyncBatchDelivery")
        private ClientObjectFactory clientObjectFactory;
        @PluginBuilderAttribute
        private int deliveryInterval = 1000;
        @PluginBuilderAttribute
        private int batchSize = 1000;
        @PluginElement(value="failoverPolicy")
        private FailoverPolicy failoverPolicy = DEFAULT_FAILOVER_POLICY;
        @PluginElement(value="indexTemplate")
        private IndexTemplate indexTemplate;

        public AsyncBatchDelivery build() {
            if (this.clientObjectFactory == null) {
                throw new ConfigurationException("No Elasticsearch client factory [JestHttp|ElasticsearchBulkProcessor] provided for AsyncBatchDelivery");
            }
            return new AsyncBatchDelivery(this.batchSize, this.deliveryInterval, this.clientObjectFactory, this.failoverPolicy, this.indexTemplate);
        }

        public Builder withClientObjectFactory(ClientObjectFactory clientObjectFactory) {
            this.clientObjectFactory = clientObjectFactory;
            return this;
        }

        public Builder withDeliveryInterval(int deliveryInterval) {
            this.deliveryInterval = deliveryInterval;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withFailoverPolicy(FailoverPolicy failoverPolicy) {
            this.failoverPolicy = failoverPolicy;
            return this;
        }

        public Builder withIndexTemplate(IndexTemplate indexTemplate) {
            this.indexTemplate = indexTemplate;
            return this;
        }
    }
}

