/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;

public class BulkEmitter<BATCH_TYPE>
implements BatchEmitter {
    private final AtomicInteger size = new AtomicInteger();
    private final int maxSize;
    private final int interval;
    private final BatchOperations<BATCH_TYPE> batchOperations;
    private final AtomicReference<BatchBuilder<BATCH_TYPE>> builder;
    private final Timer scheduler = new Timer();
    private Function<BATCH_TYPE, Boolean> listener;
    private final ListenerLock listenerLock = new ListenerLock();

    public BulkEmitter(int atSize, int intervalInMillis, BatchOperations<BATCH_TYPE> batchOperations) {
        this.maxSize = atSize;
        this.interval = intervalInMillis;
        this.batchOperations = batchOperations;
        this.builder = new AtomicReference<BatchBuilder<BATCH_TYPE>>(batchOperations.createBatchBuilder());
        this.scheduler.scheduleAtFixedRate(this.createNotificationTask(), 0L, (long)this.interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyListener() {
        ListenerLock listenerLock = this.listenerLock;
        synchronized (listenerLock) {
            if (this.size.get() == 0) {
                return;
            }
            this.size.set(0);
            this.listener.apply(this.builder.getAndSet(this.batchOperations.createBatchBuilder()).build());
        }
    }

    public void add(Object batchItem) {
        this.builder.get().add(batchItem);
        if (this.size.incrementAndGet() >= this.maxSize) {
            this.notifyListener();
        }
    }

    private TimerTask createNotificationTask() {
        return new TimerTask(){

            @Override
            public void run() {
                BulkEmitter.this.notifyListener();
            }
        };
    }

    public void addListener(Function<BATCH_TYPE, Boolean> onReadyListener) {
        this.listener = onReadyListener;
    }

    private class ListenerLock {
        private ListenerLock() {
        }
    }
}

