/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.IndexNameFormatter;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemAppenderFactory;
import org.appenders.log4j2.elasticsearch.JacksonJsonLayout;
import org.appenders.log4j2.elasticsearch.NoopIndexNameFormatter;

@Plugin(name="Elasticsearch", category="Core", elementType="appender", printObject=true)
public class ElasticsearchAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "Elasticsearch";
    private IndexNameFormatter indexNameFormatter;
    private final ItemAppender<LogEvent> itemAppender;

    protected ElasticsearchAppender(String name, Filter filter, AbstractLayout layout, boolean ignoreExceptions, BatchDelivery batchDelivery, boolean messageOnly, IndexNameFormatter indexNameFormatter) {
        super(name, filter, (Layout)layout, ignoreExceptions);
        this.indexNameFormatter = indexNameFormatter;
        this.itemAppender = this.createItemAppenderFactory().createInstance(messageOnly, layout, batchDelivery);
    }

    protected ItemAppenderFactory createItemAppenderFactory() {
        return new ItemAppenderFactory();
    }

    public void append(LogEvent event) {
        String formattedIndexName = this.indexNameFormatter.format(event);
        this.itemAppender.append(formattedIndexName, event);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ElasticsearchAppender> {
        public static final IndexNameFormatter DEFAULT_INDEX_NAME_FORMATTER = NoopIndexNameFormatter.newBuilder().withIndexName("log4j2").build();
        @PluginBuilderAttribute
        @Required(message="No name provided for Elasticsearch appender")
        private String name;
        @PluginElement(value="filter")
        private Filter filter;
        @PluginElement(value="layout")
        private AbstractLayout layout;
        @PluginBuilderAttribute
        private boolean ignoreExceptions;
        @PluginElement(value="batchDelivery")
        @Required(message="No BatchDelivery method provided for ElasticSearch appender")
        private BatchDelivery batchDelivery;
        @PluginBuilderAttribute
        private boolean messageOnly;
        @PluginElement(value="indexNameFormatter")
        private IndexNameFormatter indexNameFormatter = DEFAULT_INDEX_NAME_FORMATTER;

        public ElasticsearchAppender build() {
            if (this.name == null) {
                throw new ConfigurationException("No name provided for Elasticsearch appender");
            }
            if (this.batchDelivery == null) {
                throw new ConfigurationException("No batchDelivery [AsyncBatchDelivery] provided for Elasticsearch appender");
            }
            if (this.layout == null) {
                this.layout = JacksonJsonLayout.newBuilder().build();
            }
            return new ElasticsearchAppender(this.name, this.filter, this.layout, this.ignoreExceptions, this.batchDelivery, this.messageOnly, this.indexNameFormatter);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withLayout(AbstractLayout layout) {
            this.layout = layout;
            return this;
        }

        public Builder withIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Builder withBatchDelivery(BatchDelivery batchDelivery) {
            this.batchDelivery = batchDelivery;
            return this;
        }

        public Builder withMessageOnly(boolean messageOnly) {
            this.messageOnly = messageOnly;
            return this;
        }

        public Builder withIndexNameFormatter(IndexNameFormatter indexNameFormatter) {
            this.indexNameFormatter = indexNameFormatter;
            return this;
        }
    }
}

