/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.jackson.ExtendedLog4j2JsonModule;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.message.Message;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ItemSourceLayout;
import org.appenders.log4j2.elasticsearch.JacksonAfterburnerModuleConfigurer;
import org.appenders.log4j2.elasticsearch.JacksonMixIn;
import org.appenders.log4j2.elasticsearch.StringItemSourceFactory;

@Plugin(name="JacksonJsonLayout", category="Core", elementType="layout", printObject=true)
public class JacksonJsonLayout
extends AbstractLayout<ItemSource>
implements ItemSourceLayout {
    public static final String PLUGIN_NAME = "JacksonJsonLayout";
    private final ObjectWriter objectWriter;
    private final ItemSourceFactory itemSourceFactory;

    protected JacksonJsonLayout(Configuration config, ObjectWriter configuredWriter, ItemSourceFactory itemSourceFactory) {
        super(config, null, null);
        this.objectWriter = configuredWriter;
        this.itemSourceFactory = itemSourceFactory;
    }

    public String getContentType() {
        return "application/json";
    }

    public byte[] toByteArray(LogEvent event) {
        throw new UnsupportedOperationException("Cannot return unwrapped byte array. Use ItemSource based API");
    }

    public final ItemSource toSerializable(LogEvent event) {
        return this.serialize(event);
    }

    @Override
    public final ItemSource serialize(LogEvent event) {
        return this.itemSourceFactory.create(event, this.objectWriter);
    }

    @Override
    public final ItemSource serialize(Message message) {
        return this.itemSourceFactory.create(message, this.objectWriter);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractLayout.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<JacksonJsonLayout> {
        static final ItemSourceFactory DEFAULT_SOURCE_FACTORY = StringItemSourceFactory.newBuilder().build();
        @PluginElement(value="itemSourceFactory")
        private ItemSourceFactory itemSourceFactory = DEFAULT_SOURCE_FACTORY;
        @PluginElement(value="jacksonMixIn")
        private JacksonMixIn[] mixins = new JacksonMixIn[0];
        @PluginBuilderAttribute(value="afterburner")
        private boolean useAfterburner;

        public JacksonJsonLayout build() {
            return new JacksonJsonLayout(this.getConfiguration(), this.createConfiguredWriter(Arrays.asList(this.mixins)), this.itemSourceFactory);
        }

        protected ObjectWriter createConfiguredWriter(List<JacksonMixIn> mixins) {
            ObjectMapper objectMapper = this.createDefaultObjectMapper();
            objectMapper.registerModule((Module)new ExtendedLog4j2JsonModule());
            if (this.useAfterburner) {
                new JacksonAfterburnerModuleConfigurer().configure(objectMapper);
            }
            for (JacksonMixIn mixin : mixins) {
                objectMapper.addMixIn(mixin.getTargetClass(), mixin.getMixInClass());
            }
            return objectMapper.writer((PrettyPrinter)new MinimalPrettyPrinter());
        }

        protected ObjectMapper createDefaultObjectMapper() {
            return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.CLOSE_CLOSEABLE, false);
        }

        public Builder withItemSourceFactory(ItemSourceFactory itemSourceFactory) {
            this.itemSourceFactory = itemSourceFactory;
            return this;
        }

        public Builder withMixins(JacksonMixIn ... mixins) {
            this.mixins = mixins;
            return this;
        }

        public Builder withAfterburner(boolean useAfterburner) {
            this.useAfterburner = useAfterburner;
            return this;
        }
    }
}

