/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.appenders.log4j2.elasticsearch.BufferedItemSourcePool;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.ResizePolicy;
import org.appenders.log4j2.elasticsearch.UnlimitedResizePolicy;

@Plugin(name="PooledItemSourceFactory", category="Core", elementType="itemSourceFactory", printObject=true)
public class PooledItemSourceFactory
extends AbstractLifeCycle
implements ItemSourceFactory {
    public static final String PLUGIN_NAME = "PooledItemSourceFactory";
    final ItemSourcePool bufferedItemSourcePool;

    protected PooledItemSourceFactory(ItemSourcePool bufferedItemSourcePool) {
        this.bufferedItemSourcePool = bufferedItemSourcePool;
    }

    @Override
    public final boolean isBuffered() {
        return true;
    }

    @Override
    public ItemSource create(Object source, ObjectWriter objectWriter) {
        ItemSource pooled;
        try {
            pooled = this.bufferedItemSourcePool.getPooled();
        }
        catch (PoolResourceException e) {
            throw new IllegalStateException(e);
        }
        try {
            objectWriter.writeValue((DataOutput)new ByteBufOutputStream((ByteBuf)pooled.getSource()), source);
            return pooled;
        }
        catch (IOException e) {
            pooled.release();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ItemSource createEmptySource() {
        try {
            return this.bufferedItemSourcePool.getPooled();
        }
        catch (PoolResourceException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.bufferedItemSourcePool.shutdown();
        return super.stop(timeout, timeUnit);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PooledItemSourceFactory> {
        public static final long DEFAULT_RESIZE_TIMEOUT = 1000L;
        public static final long DEFAULT_MONITOR_TASK_INTERVAL = 30000L;
        @PluginBuilderAttribute
        protected String poolName;
        @PluginElement(value="resizePolicy")
        protected ResizePolicy resizePolicy;
        @PluginBuilderAttribute
        protected int itemSizeInBytes;
        @PluginBuilderAttribute
        protected int initialPoolSize;
        @PluginBuilderAttribute
        protected boolean monitored;
        @PluginBuilderAttribute
        protected long monitorTaskInterval = 30000L;
        @PluginBuilderAttribute
        protected long resizeTimeout = 1000L;

        public PooledItemSourceFactory build() {
            if (this.initialPoolSize <= 0) {
                throw new ConfigurationException("initialPoolSize must be higher than 0 for PooledItemSourceFactory");
            }
            if (this.itemSizeInBytes <= 0) {
                throw new ConfigurationException("itemSizeInBytes must be higher than 0 for PooledItemSourceFactory");
            }
            if (this.poolName == null) {
                this.poolName = UUID.randomUUID().toString();
            }
            if (this.resizePolicy == null) {
                ResizePolicy resizePolicy = this.createResizePolicy();
                LOGGER.info("No configured {} found for pool {}. Defaulting to {}", (Object)"resizePolicy", (Object)this.poolName, (Object)resizePolicy.getClass().getSimpleName());
                this.resizePolicy = resizePolicy;
            }
            return new PooledItemSourceFactory(this.configuredBufferedItemSourcePool());
        }

        ResizePolicy createResizePolicy() {
            return UnlimitedResizePolicy.newBuilder().build();
        }

        ItemSourcePool configuredBufferedItemSourcePool() {
            return new BufferedItemSourcePool(this.poolName, new UnpooledByteBufAllocator(false, false, false), this.resizePolicy, this.resizeTimeout, this.monitored, this.monitorTaskInterval, this.initialPoolSize, this.itemSizeInBytes);
        }

        public Builder withItemSizeInBytes(int itemSizeInBytes) {
            this.itemSizeInBytes = itemSizeInBytes;
            return this;
        }

        public Builder withInitialPoolSize(int initialPoolSize) {
            this.initialPoolSize = initialPoolSize;
            return this;
        }

        public Builder withPoolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public Builder withResizePolicy(ResizePolicy resizePolicy) {
            this.resizePolicy = resizePolicy;
            return this;
        }

        public Builder withMonitored(boolean monitored) {
            this.monitored = monitored;
            return this;
        }

        public Builder withMonitorTaskInterval(long monitorTaskInterval) {
            this.monitorTaskInterval = monitorTaskInterval;
            return this;
        }

        public Builder withResizeTimeout(long resizeTimeout) {
            this.resizeTimeout = resizeTimeout;
            return this;
        }
    }
}

