/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceFactory;
import org.appenders.log4j2.elasticsearch.StringItemSource;

@Plugin(name="StringItemSourceAppender", category="Core", elementType="itemSourceFactory", printObject=true)
public class StringItemSourceFactory
implements ItemSourceFactory {
    static final String PLUGIN_NAME = "StringItemSourceAppender";
    private static final Logger LOGGER = StatusLogger.getLogger();

    StringItemSourceFactory() {
    }

    @Override
    public final boolean isBuffered() {
        return false;
    }

    @Override
    public ItemSource create(Object event, ObjectWriter objectWriter) {
        try {
            return new StringItemSource(objectWriter.writeValueAsString(event));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot write item source: " + e.getMessage());
            return null;
        }
    }

    @Override
    public ItemSource createEmptySource() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot create empty source. Use buffer-based classes instead");
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<StringItemSourceFactory> {
        public StringItemSourceFactory build() {
            return new StringItemSourceFactory();
        }
    }
}

