/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.spi;

import java.util.ServiceLoader;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.status.StatusLogger;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;

public class BatchEmitterServiceProvider {
    private static final Logger LOG = StatusLogger.getLogger();

    public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
        ServiceLoader<BatchEmitterFactory> loader = ServiceLoader.load(BatchEmitterFactory.class);
        for (BatchEmitterFactory factory : loader) {
            LOG.info("BatchEmitterFactory class found {}", (Object)factory.getClass().getName());
            if (!factory.accepts(clientObjectFactory.getClass())) continue;
            LOG.info("Using {} as BatchEmitterFactoryProvider", (Object)factory);
            return factory.createInstance(batchSize, deliveryInterval, clientObjectFactory, failoverPolicy);
        }
        throw new ConfigurationException(String.format("No compatible BatchEmitter implementations for %s found", clientObjectFactory.getClass().getName()));
    }
}

