/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.appenders.log4j2.elasticsearch.BufferedItemSource;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.ResizePolicy;

class BufferedItemSourcePool
implements ItemSourcePool<ByteBuf> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final int INITIAL_RESIZE_INTERNAL_STACK_DEPTH = 0;
    private static final int MAX_RESIZE_INTERNAL_STACK_DEPTH = 50;
    ScheduledExecutorService executor;
    private final String poolName;
    private final UnpooledByteBufAllocator byteBufAllocator;
    private final ConcurrentLinkedQueue<ItemSource<ByteBuf>> objectPool = new ConcurrentLinkedQueue();
    private final int estimatedSourceSize;
    private final ResizePolicy resizePolicy;
    private final long resizeTimeout;
    private final AtomicBoolean resizing = new AtomicBoolean();
    private final AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final int initialPoolSize;
    private final AtomicInteger totalPoolSize;

    BufferedItemSourcePool(String poolName, UnpooledByteBufAllocator byteBufAllocator, ResizePolicy resizePolicy, long resizeTimeout, boolean monitored, long monitorTaskInterval, int initialPoolSize, int itemSizeInBytes) {
        this.poolName = poolName;
        this.byteBufAllocator = byteBufAllocator;
        this.resizePolicy = resizePolicy;
        this.resizeTimeout = resizeTimeout;
        this.initialPoolSize = initialPoolSize;
        this.totalPoolSize = new AtomicInteger();
        this.estimatedSourceSize = itemSizeInBytes;
        this.executor = this.createExecutor();
        this.incrementPoolSize(initialPoolSize);
        this.startRecyclerTask();
        if (monitored) {
            this.startMonitorTask(monitorTaskInterval);
        }
    }

    private void startRecyclerTask() {
        this.executor.scheduleAtFixedRate(new Recycler(this, this.resizePolicy), 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    void startMonitorTask(long monitorTaskInterval) {
        this.executor.scheduleAtFixedRate(new MetricPrinter(this.getName(), this.byteBufAllocator.metric(), new PoolMetrics()), 1000L, monitorTaskInterval, TimeUnit.MILLISECONDS);
    }

    ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public final void incrementPoolSize(int delta) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < delta; ++i) {
            this.incrementPoolSize();
        }
        LOGGER.info("Pool [{}] {} pooled elements added. Total pooled elements: {}. Took: {}ms", (Object)this.getName(), (Object)delta, (Object)this.getTotalSize(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public final void incrementPoolSize() {
        CompositeByteBuf buffer = new CompositeByteBuf((ByteBufAllocator)this.byteBufAllocator, false, 2).capacity(this.estimatedSourceSize);
        this.objectPool.add(new BufferedItemSource((ByteBuf)buffer, bufferedItemSource -> {
            ((ByteBuf)bufferedItemSource.getSource()).clear();
            this.objectPool.add(bufferedItemSource);
        }));
        this.totalPoolSize.getAndIncrement();
    }

    @Override
    public ItemSource<ByteBuf> getPooled() throws PoolResourceException {
        return this.removeInternal(0);
    }

    @Override
    public boolean remove() {
        try {
            this.removeInternal(50).getSource().release();
            this.totalPoolSize.getAndDecrement();
        }
        catch (PoolResourceException e) {
            return false;
        }
        return true;
    }

    private ItemSource<ByteBuf> removeInternal(int depth) throws PoolResourceException {
        try {
            if (this.objectPool.isEmpty()) {
                this.tryResize(depth);
            }
            return (ItemSource)this.objectPool.remove();
        }
        catch (NoSuchElementException e) {
            this.tryResize(depth);
            return this.removeInternal(++depth);
        }
    }

    private boolean tryResize(int depth) throws PoolResourceException {
        if (depth > 50) {
            throw new PoolResourceException(String.format("ResizePolicy is ineffective. Pool %s has to be reconfigured to handle current load.", this.poolName));
        }
        if (this.resizing.compareAndSet(false, true)) {
            this.countDownLatch.set(new CountDownLatch(1));
            return this.resize(result -> {
                this.countDownLatch.get().countDown();
                this.resizing.set(false);
            });
        }
        try {
            this.countDownLatch.get().await(this.resizeTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            throw new IllegalStateException("Thread interrupted while waiting for resizing to complete");
        }
        return false;
    }

    private boolean resize(Consumer<Boolean> callback) throws PoolResourceException {
        boolean resized = false;
        try {
            LOGGER.info("Pool [{}] attempting to resize using policy [{}]", (Object)this.getName(), (Object)this.resizePolicy.getClass().getName());
            resized = this.resizePolicy.increase(this);
            if (!resized) {
                throw new PoolResourceException(String.format("Unable to resize. Creation of %s was unsuccessful", ItemSource.class.getSimpleName()));
            }
        }
        finally {
            callback.accept(resized);
        }
        return resized;
    }

    @Override
    public String getName() {
        return this.poolName;
    }

    @Override
    public int getInitialSize() {
        return this.initialPoolSize;
    }

    @Override
    public int getTotalSize() {
        return this.totalPoolSize.get();
    }

    @Override
    public final int getAvailableSize() {
        return this.objectPool.size();
    }

    @Override
    public void shutdown() {
        this.objectPool.forEach((Consumer<ItemSource<ByteBuf>>)((Consumer<ItemSource>)pooled -> ((ByteBuf)pooled.getSource()).release()));
        this.objectPool.clear();
        this.executor.shutdown();
    }

    class PoolMetrics {
        PoolMetrics() {
        }

        public String toString() {
            return this.formattedMetrics(null);
        }

        public String formattedMetrics(ByteBufAllocatorMetric allocatorMetric) {
            int capacity = allocatorMetric != null ? 384 : 96;
            StringBuilder sb = new StringBuilder(capacity).append('{').append(" poolName: ").append(BufferedItemSourcePool.this.getName()).append(", initialPoolSize: ").append(BufferedItemSourcePool.this.getInitialSize()).append(", totalPoolSize: ").append(BufferedItemSourcePool.this.getTotalSize()).append(", availablePoolSize: ").append(BufferedItemSourcePool.this.getAvailableSize());
            if (allocatorMetric != null) {
                sb.append(", allocatorMetric: ").append(allocatorMetric);
            }
            return sb.append('}').toString();
        }
    }

    static class MetricPrinter
    extends Thread {
        private final Consumer<ByteBufAllocatorMetric> printer;
        private final ByteBufAllocatorMetric allocatorMetric;

        MetricPrinter(String threadName, ByteBufAllocatorMetric allocatorMetric, PoolMetrics poolMetrics) {
            super(threadName);
            this.allocatorMetric = allocatorMetric;
            this.printer = metric -> LOGGER.info(poolMetrics.formattedMetrics(allocatorMetric));
        }

        @Override
        public void run() {
            this.printer.accept(this.allocatorMetric);
        }
    }

    static class Recycler
    extends Thread {
        private final BufferedItemSourcePool pool;
        private final ResizePolicy resizePolicy;

        Recycler(BufferedItemSourcePool pool, ResizePolicy resizePolicy) {
            super(pool.getName() + "-Recycler");
            this.pool = pool;
            this.resizePolicy = resizePolicy;
        }

        @Override
        public void run() {
            this.resizePolicy.decrease(this.pool);
        }
    }
}

