/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemSourceAppender;
import org.appenders.log4j2.elasticsearch.ItemSourceLayout;
import org.appenders.log4j2.elasticsearch.StringAppender;

public class ItemAppenderFactory {
    public ItemAppender createInstance(boolean messageOnly, AbstractLayout layout, BatchDelivery batchDelivery) {
        if (layout instanceof ItemSourceLayout) {
            ItemSourceLayout itemSourceLayout = (ItemSourceLayout)layout;
            return this.createInstance(messageOnly, itemSourceLayout, batchDelivery);
        }
        if (messageOnly) {
            return new StringAppender(batchDelivery, logEvent -> logEvent.getMessage().getFormattedMessage());
        }
        if (layout instanceof AbstractStringLayout) {
            AbstractStringLayout abstractStringLayout = (AbstractStringLayout)layout;
            return new StringAppender(batchDelivery, arg_0 -> ((AbstractStringLayout)abstractStringLayout).toSerializable(arg_0));
        }
        throw new ConfigurationException("Unsupported layout: " + layout.getClass());
    }

    public ItemSourceAppender createInstance(boolean messageOnly, ItemSourceLayout itemSourceLayout, BatchDelivery batchDelivery) {
        if (messageOnly) {
            return new ItemSourceAppender(batchDelivery, logEvent -> itemSourceLayout.serialize(logEvent.getMessage()));
        }
        return new ItemSourceAppender(batchDelivery, itemSourceLayout::serialize);
    }
}

