/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.appenders.log4j2.elasticsearch.IndexNameFormatter;

@Plugin(name="RollingIndexName", category="Core", elementType="indexNameFormatter", printObject=true)
public class RollingIndexNameFormatter
implements IndexNameFormatter {
    public static final String SEPARATOR = "-";
    private String indexName;
    private String currentName;
    private long nextRolloverTime;
    private final AtomicBoolean rollingOver = new AtomicBoolean();
    private final PatternProcessor patternProcessor;
    private FastDateFormat fastDateFormat;
    private int DEFAULT_BUFFER_SIZE = 32;
    private long currentFileTime;

    protected RollingIndexNameFormatter(String indexName, String pattern, long initTimeInMillis, TimeZone timeZone) {
        this.indexName = indexName;
        this.fastDateFormat = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone);
        this.patternProcessor = this.createPatternProcessor(pattern);
        this.currentName = this.doFormat(indexName, initTimeInMillis);
        long previousTime = this.patternProcessor.getNextTime(initTimeInMillis, -1, false);
        this.patternProcessor.setPrevFileTime(previousTime);
        this.currentFileTime = this.nextRolloverTime = this.patternProcessor.getNextTime(initTimeInMillis, 0, false);
    }

    protected PatternProcessor createPatternProcessor(String pattern) {
        return new PatternProcessor("%d{" + pattern + "}");
    }

    long getNextRolloverTime() {
        return this.nextRolloverTime;
    }

    @Override
    public final String format(LogEvent event) {
        long eventTimeInMillis = event.getTimeMillis();
        if (eventTimeInMillis < this.currentFileTime) {
            return this.doFormat(this.indexName, eventTimeInMillis);
        }
        if (eventTimeInMillis >= this.nextRolloverTime && this.rollingOver.compareAndSet(false, true)) {
            this.rollover(this.indexName, eventTimeInMillis);
            this.rollingOver.set(false);
        }
        if (!this.rollingOver.get()) {
            return this.currentName;
        }
        return this.doFormat(this.indexName, eventTimeInMillis);
    }

    private void rollover(String indexName, long eventTimeInMillis) {
        this.nextRolloverTime = this.patternProcessor.getNextTime(eventTimeInMillis, 1, false);
        this.currentFileTime = this.patternProcessor.getNextTime(eventTimeInMillis, 0, false);
        this.currentName = this.doFormat(indexName, eventTimeInMillis);
    }

    private String doFormat(String indexName, long timeInMillis) {
        return ((StringBuilder)this.fastDateFormat.format(timeInMillis, (Appendable)this.buffer(indexName).append(SEPARATOR))).toString();
    }

    private StringBuilder buffer(String indexName) {
        return new StringBuilder(this.DEFAULT_BUFFER_SIZE).append(indexName);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RollingIndexNameFormatter> {
        public static final String DEFAULT_TIME_ZONE = TimeZone.getDefault().getID();
        @PluginBuilderAttribute
        @Required(message="No indexName provided for RollingIndexName")
        private String indexName;
        @PluginBuilderAttribute
        @Required(message="No pattern provided for RollingIndexName")
        private String pattern;
        @PluginBuilderAttribute
        private String timeZone = DEFAULT_TIME_ZONE;

        public RollingIndexNameFormatter build() {
            if (this.indexName == null) {
                throw new ConfigurationException("No indexName provided for RollingIndexName");
            }
            if (this.pattern == null) {
                throw new ConfigurationException("No pattern provided for RollingIndexName");
            }
            return new RollingIndexNameFormatter(this.indexName, this.pattern, this.getInitTimeInMillis(), TimeZone.getTimeZone(this.timeZone));
        }

        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withTimeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        long getInitTimeInMillis() {
            return System.currentTimeMillis();
        }
    }
}

