/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.ResizePolicy;

@Plugin(name="UnlimitedResizePolicy", category="Core", elementType="resizePolicy", printObject=true)
public final class UnlimitedResizePolicy
implements ResizePolicy {
    public static final String PLUGIN_NAME = "UnlimitedResizePolicy";
    private final double resizeFactor;

    private UnlimitedResizePolicy(double resizeFactor) {
        this.resizeFactor = resizeFactor;
    }

    @Override
    public boolean increase(ItemSourcePool itemSourcePool) {
        int initialPoolSize = itemSourcePool.getInitialSize();
        int additionalPoolSize = (int)((double)initialPoolSize * this.resizeFactor);
        if (additionalPoolSize == 0) {
            throw new ConfigurationException(String.format("Applying %s with resizeFactor %s will not resize given pool [%s] with initialPoolSize %s", ResizePolicy.class.getSimpleName(), this.resizeFactor, itemSourcePool.getName(), itemSourcePool.getInitialSize()));
        }
        itemSourcePool.incrementPoolSize(additionalPoolSize);
        return true;
    }

    @Override
    public boolean decrease(ItemSourcePool itemSourcePool) {
        int availableSize = itemSourcePool.getAvailableSize();
        int decreaseSize = (int)((double)itemSourcePool.getTotalSize() * this.resizeFactor);
        if (decreaseSize > availableSize) {
            return false;
        }
        if (availableSize - decreaseSize < itemSourcePool.getInitialSize()) {
            decreaseSize = availableSize - itemSourcePool.getInitialSize();
        }
        for (int ii = 0; ii < decreaseSize; ++ii) {
            itemSourcePool.remove();
        }
        return true;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<UnlimitedResizePolicy> {
        public static final double DEFAULT_RESIZE_FACTOR = 0.5;
        @PluginBuilderAttribute
        private double resizeFactor = 0.5;

        public UnlimitedResizePolicy build() {
            if (this.resizeFactor <= 0.0) {
                throw new ConfigurationException("resizeFactor must be higher than 0");
            }
            if (this.resizeFactor > 1.0) {
                throw new ConfigurationException("resizeFactor must be lower or equal 1");
            }
            return new UnlimitedResizePolicy(this.resizeFactor);
        }

        public Builder withResizeFactor(double resizeFactor) {
            this.resizeFactor = resizeFactor;
            return this;
        }
    }
}

