/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.AppenderRefFailoverPolicy;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AppenderRefFailoverPolicyTest {
    @Test
    public void deliversToAppenderRef() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn((Object)appender);
        FailoverPolicy<String> failoverPolicy = AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration);
        String failedMessage = "test failed message";
        failoverPolicy.deliver((Object)failedMessage);
        ((Appender)Mockito.verify((Object)appender, (VerificationMode)Mockito.times((int)1))).append((LogEvent)Matchers.any(LogEvent.class));
    }

    @Test
    public void resolvesAppenderRefOnlyOnce() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn((Object)appender);
        FailoverPolicy<String> failoverPolicy = AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration);
        String failedMessage = "test failed message";
        failoverPolicy.deliver((Object)failedMessage);
        failoverPolicy.deliver((Object)failedMessage);
        ((Configuration)Mockito.verify((Object)configuration, (VerificationMode)Mockito.times((int)1))).getAppender(Mockito.anyString());
        ((Appender)Mockito.verify((Object)appender, (VerificationMode)Mockito.times((int)2))).append((LogEvent)Matchers.any(LogEvent.class));
    }

    @Test(expected=ConfigurationException.class)
    public void throwsExceptionOnUnresolvedAppender() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn(null);
        FailoverPolicy<String> failoverPolicy = AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration);
        String failedMessage = "test failed message";
        failoverPolicy.deliver((Object)failedMessage);
    }

    public static FailoverPolicy<String> createTestFailoverPolicy(String testAppenderRef, Configuration configuration) {
        AppenderRefFailoverPolicy.Builder builder = AppenderRefFailoverPolicy.newBuilder();
        builder.withAppenderRef(AppenderRef.createAppenderRef((String)testAppenderRef, (Level)Level.ALL, null));
        builder.withConfiguration(configuration);
        return builder.build();
    }
}

