/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.TestPooledByteBufAllocatorMetric;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.appenders.log4j2.elasticsearch.BufferedItemSource;
import org.appenders.log4j2.elasticsearch.BufferedItemSourcePool;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.ResizePolicy;
import org.appenders.log4j2.elasticsearch.UnlimitedResizePolicy;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BufferedItemSourcePoolTest {
    public static final String DEFAULT_TEST_ITEM_POOL_NAME = "testPool";
    public static final int DEFAULT_TEST_INITIAL_POOL_SIZE = 10;
    public static final int DEFAULT_TEST_ITEM_SIZE_IN_BYTES = 1024;
    public static final long DEFAULT_TEST_MONITOR_TASK_INTERVAL = 1000L;
    public static final int DEFAULT_TEST_RESIZE_TIMEOUT = 100;
    public static UnpooledByteBufAllocator byteBufAllocator;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void poolShutdownShutsDownExecutor() {
        ScheduledExecutorService mockedExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true, mockedExecutor);
        pool.start();
        pool.shutdown();
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutor)).shutdown();
    }

    @Test
    public void monitoredPoolExecutorSchedulesMetricPrinterThread() {
        ScheduledExecutorService spiedExecutor = (ScheduledExecutorService)Mockito.spy(ScheduledExecutorService.class);
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true, spiedExecutor);
        pool.start();
        ArgumentCaptor runnableCaptor = ArgumentCaptor.forClass(BufferedItemSourcePool.Recycler.class);
        ((ScheduledExecutorService)Mockito.verify((Object)spiedExecutor)).scheduleAtFixedRate((Runnable)runnableCaptor.capture(), Matchers.anyLong(), Matchers.eq((long)1000L), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
    }

    @Test
    public void poolShutdownClearsSourceList() {
        ScheduledExecutorService mockedExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        BufferedItemSourcePool pool = this.started(this.createDefaultTestBufferedItemSourcePool(false, mockedExecutor));
        pool.incrementPoolSize();
        Assert.assertEquals((long)11L, (long)pool.getAvailableSize());
        pool.shutdown();
        Assert.assertEquals((long)0L, (long)pool.getAvailableSize());
    }

    private BufferedItemSourcePool started(BufferedItemSourcePool managed) {
        managed.start();
        return managed;
    }

    @Test
    public void monitoredPoolExecutorFactoryDoesNotReturnNull() {
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true);
        ScheduledExecutorService executor = pool.createExecutor();
        Assert.assertNotNull((Object)executor);
    }

    @Test
    public void metricsPrinterToStringDelegatesToFormattedMetrics() {
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true);
        BufferedItemSourcePool.PoolMetrics metrics = (BufferedItemSourcePool.PoolMetrics)Mockito.spy((Object)new BufferedItemSourcePool.PoolMetrics(pool));
        metrics.toString();
        ((BufferedItemSourcePool.PoolMetrics)Mockito.verify((Object)metrics)).formattedMetrics((ByteBufAllocatorMetric)Matchers.eq(null));
    }

    @Test
    public void metricsPrinterGivenNoAllocatorMetricsContainsPoolStatsOnly() throws PoolResourceException {
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true);
        pool.start();
        BufferedItemSourcePool.PoolMetrics metrics = new BufferedItemSourcePool.PoolMetrics(pool);
        pool.incrementPoolSize();
        pool.getPooled();
        String formattedMetrics = metrics.formattedMetrics(null);
        Assert.assertTrue((boolean)formattedMetrics.contains("poolName: testPool"));
        Assert.assertTrue((boolean)formattedMetrics.contains("initialPoolSize: 10"));
        Assert.assertTrue((boolean)formattedMetrics.contains("totalPoolSize: 11"));
        Assert.assertTrue((boolean)formattedMetrics.contains("availablePoolSize: 10"));
        Assert.assertFalse((boolean)formattedMetrics.contains("allocatorMetric"));
    }

    @Test
    public void metricsPrinterContainsPoolStats() throws PoolResourceException {
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true);
        pool.start();
        BufferedItemSourcePool.PoolMetrics metrics = new BufferedItemSourcePool.PoolMetrics(pool);
        TestPooledByteBufAllocatorMetric allocatorMetrics = new TestPooledByteBufAllocatorMetric();
        pool.incrementPoolSize();
        pool.getPooled();
        String formattedMetrics = metrics.formattedMetrics(allocatorMetrics.getDelegate());
        Assert.assertTrue((boolean)formattedMetrics.contains("poolName: testPool"));
        Assert.assertTrue((boolean)formattedMetrics.contains("initialPoolSize: 10"));
        Assert.assertTrue((boolean)formattedMetrics.contains("totalPoolSize: 11"));
        Assert.assertTrue((boolean)formattedMetrics.contains("availablePoolSize: 10"));
        Assert.assertTrue((boolean)formattedMetrics.contains("allocatorMetric"));
    }

    @Test
    public void incrementSizeAddsOnePooledElement() throws PoolResourceException {
        BufferedItemSourcePool pool = BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(0, false);
        pool.incrementPoolSize();
        Assert.assertEquals((long)1L, (long)pool.getAvailableSize());
        ItemSource itemSource = pool.getPooled();
        Assert.assertNotNull((Object)itemSource);
    }

    @Test
    public void incrementSizeByNumberAddsExactNumberOfPooledElements() throws PoolResourceException {
        ItemSource itemSource;
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(0, false));
        int expectedNumberOfPooledItemSources = 10;
        pool.incrementPoolSize(expectedNumberOfPooledItemSources);
        int remaining = expectedNumberOfPooledItemSources;
        do {
            itemSource = pool.getPooled();
            Assert.assertEquals((long)(--remaining), (long)pool.getAvailableSize());
        } while (remaining > 0);
        Assert.assertNotNull((Object)itemSource);
        Assert.assertEquals((long)0L, (long)remaining);
    }

    @Test
    public void defaultReleaseCallbackReturnsPooledElement() throws PoolResourceException {
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(false);
        pool.start();
        Assert.assertEquals((long)10L, (long)pool.getAvailableSize());
        pool.incrementPoolSize();
        Assert.assertEquals((long)11L, (long)pool.getAvailableSize());
        ItemSource itemSource = pool.getPooled();
        Assert.assertEquals((long)10L, (long)pool.getAvailableSize());
        itemSource.release();
        Assert.assertEquals((long)11L, (long)pool.getAvailableSize());
    }

    @Test
    public void defaultReleaseCallbackDoesntReturnToPoolIfPoolIsStopped() throws PoolResourceException {
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)UnlimitedResizePolicy.newBuilder().withResizeFactor(1.0).build(), 100L, false, 1000L, 1, 1024){

            BufferedItemSource createBufferedItemSource() {
                return (BufferedItemSource)Mockito.spy((Object)super.createBufferedItemSource());
            }
        });
        pool.start();
        Assert.assertTrue((boolean)pool.isStarted());
        Assert.assertTrue((pool.getAvailableSize() > 0 ? 1 : 0) != 0);
        ItemSource pooled = pool.getPooled();
        ByteBuf byteBuf = (ByteBuf)Mockito.spy((Object)pooled.getSource());
        Mockito.when((Object)pooled.getSource()).thenReturn((Object)byteBuf);
        pool.stop();
        pooled.release();
        Assert.assertEquals((long)0L, (long)pool.getAvailableSize());
        ((ByteBuf)Mockito.verify((Object)byteBuf)).release();
    }

    @Test
    public void throwsWhenNoMorePooledElementsAvailableAndResizePolicyDoesNotCopeWithTheLoad() throws PoolResourceException {
        ResizePolicy resizePolicy = (ResizePolicy)Mockito.mock(ResizePolicy.class);
        Mockito.when((Object)resizePolicy.increase((ItemSourcePool)Matchers.any())).thenReturn((Object)true);
        BufferedItemSourcePool pool = new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, resizePolicy, 0L, false, 1000L, 0, 1024);
        this.expectedException.expect(PoolResourceException.class);
        this.expectedException.expectMessage("has to be reconfigured to handle current load");
        this.expectedException.expectMessage(DEFAULT_TEST_ITEM_POOL_NAME);
        pool.getPooled();
    }

    @Test
    public void throwsWhenResizePolicyDoesNotResize() throws PoolResourceException {
        ResizePolicy resizePolicy = (ResizePolicy)Mockito.mock(ResizePolicy.class);
        Mockito.when((Object)resizePolicy.increase((ItemSourcePool)Matchers.any())).thenReturn((Object)false);
        BufferedItemSourcePool pool = new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, resizePolicy, 0L, false, 1000L, 0, 1024);
        this.expectedException.expect(PoolResourceException.class);
        this.expectedException.expectMessage("Unable to resize. Creation of ItemSource was unsuccessful");
        pool.getPooled();
    }

    @Test
    public void removeReturnFalseInsteadOfThrowingAfterUnderlyingPoolResourceException() {
        ResizePolicy resizePolicy = (ResizePolicy)Mockito.mock(ResizePolicy.class);
        Mockito.when((Object)resizePolicy.increase((ItemSourcePool)Matchers.any())).then(invocationOnMock -> {
            throw new PoolResourceException("test");
        });
        BufferedItemSourcePool pool = new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, resizePolicy, 0L, false, 1000L, 0, 1024);
        boolean resized = pool.remove();
        Assert.assertFalse((boolean)resized);
    }

    @Test
    public void multipleThreadsGetPooledWhenResizePolicyEventuallyCopeWithTheLoad() throws PoolResourceException, InterruptedException {
        ResizePolicy resizePolicy = (ResizePolicy)Mockito.mock(ResizePolicy.class);
        final int expectedIneffectiveResizes = 30;
        final BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, resizePolicy, 100L, false, 1000L, 0, 1024));
        final AtomicInteger failedCounter = new AtomicInteger();
        Mockito.when((Object)resizePolicy.increase((ItemSourcePool)Matchers.eq((Object)pool))).thenAnswer((Answer)new Answer<Boolean>(){
            private AtomicInteger counter;
            private Random random;
            {
                this.counter = new AtomicInteger(expectedIneffectiveResizes);
                this.random = new Random();
            }

            public Boolean answer(InvocationOnMock invocation) throws InterruptedException {
                Thread.sleep(this.random.nextInt(10) + 10);
                if (this.counter.getAndDecrement() <= 0) {
                    pool.incrementPoolSize(2);
                    return true;
                }
                failedCounter.incrementAndGet();
                return true;
            }
        });
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(10);
        for (int ii = 0; ii < 10; ++ii) {
            new Thread(() -> {
                try {
                    start.await();
                    pool.getPooled();
                }
                catch (PoolResourceException e) {
                    System.out.println(e.getMessage());
                    Assert.fail();
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                finally {
                    end.countDown();
                }
            }).start();
        }
        Thread.sleep(100L);
        start.countDown();
        end.await();
        Assert.assertEquals((long)expectedIneffectiveResizes, (long)failedCounter.get());
    }

    @Test
    public void throwsWhenMultithreadedWaitForResizeInterrupted() throws InterruptedException {
        ResizePolicy resizePolicy = (ResizePolicy)Mockito.mock(ResizePolicy.class);
        int resizeTimeout = 1000;
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, resizePolicy, (long)resizeTimeout, false, 1000L, 0, 1024));
        Mockito.when((Object)resizePolicy.increase((ItemSourcePool)Matchers.eq((Object)pool))).thenAnswer(invocation -> {
            Thread.currentThread();
            Thread.sleep(1000L);
            return true;
        });
        Exception[] caught = new Exception[1];
        ArrayList<Thread> threads = new ArrayList<Thread>();
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(2);
        for (int ii = 0; ii < 2; ++ii) {
            Thread thread2 = new Thread(() -> {
                try {
                    start.await();
                    pool.getPooled();
                }
                catch (PoolResourceException e) {
                    System.out.println(e.getMessage());
                    Assert.fail();
                }
                catch (InterruptedException e) {
                }
                catch (IllegalStateException e) {
                    caught[0] = e;
                }
                finally {
                    end.countDown();
                }
            });
            threads.add(thread2);
            thread2.start();
        }
        Thread.sleep(500L);
        start.countDown();
        Thread.sleep(100L);
        threads.forEach(thread -> thread.interrupt());
        end.await();
        Assert.assertEquals(IllegalStateException.class, caught[0].getClass());
        Assert.assertEquals((Object)"Thread interrupted while waiting for resizing to complete", (Object)caught[0].getMessage());
    }

    @Test
    public void lifecycleStartCreatesScheduledExecutor() {
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)UnlimitedResizePolicy.newBuilder().withResizeFactor(1.0).build(), 100L, false, 1000L, 1, 1024));
        pool.start();
        Assert.assertNotNull((Object)pool.executor);
    }

    @Test
    public void lifecycleStartSchedulesRecyclerThread() {
        ScheduledExecutorService spiedExecutor = (ScheduledExecutorService)Mockito.spy(ScheduledExecutorService.class);
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(false, spiedExecutor);
        pool.start();
        pool.start();
        ArgumentCaptor runnableCaptor = ArgumentCaptor.forClass(BufferedItemSourcePool.Recycler.class);
        ((ScheduledExecutorService)Mockito.verify((Object)spiedExecutor)).scheduleAtFixedRate((Runnable)runnableCaptor.capture(), Matchers.anyLong(), Matchers.eq((long)10000L), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
        Assert.assertEquals((Object)"testPool-Recycler", (Object)((BufferedItemSourcePool.Recycler)runnableCaptor.getValue()).getName());
    }

    @Test
    public void lifecycleStartSchedulesMonitorThread() {
        ScheduledExecutorService spiedExecutor = (ScheduledExecutorService)Mockito.spy(ScheduledExecutorService.class);
        BufferedItemSourcePool pool = this.createDefaultTestBufferedItemSourcePool(true, spiedExecutor);
        pool.start();
        pool.start();
        ArgumentCaptor runnableCaptor = ArgumentCaptor.forClass(BufferedItemSourcePool.MetricPrinter.class);
        ((ScheduledExecutorService)Mockito.verify((Object)spiedExecutor)).scheduleAtFixedRate((Runnable)runnableCaptor.capture(), Matchers.anyLong(), Matchers.eq((long)1000L), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
        Assert.assertEquals((Object)"testPool-MetricPrinter", (Object)((BufferedItemSourcePool.MetricPrinter)runnableCaptor.getValue()).getName());
    }

    @Test
    public void lifecycleStopShutsDownPoolOnlyOnce() {
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)UnlimitedResizePolicy.newBuilder().withResizeFactor(1.0).build(), 100L, false, 1000L, 1, 1024));
        pool.start();
        pool.stop();
        pool.stop();
        ((BufferedItemSourcePool)Mockito.verify((Object)pool)).shutdown();
    }

    @Test
    public void lifecycleStopStopsReturningBuffersBackOnRelease() throws PoolResourceException {
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)UnlimitedResizePolicy.newBuilder().withResizeFactor(1.0).build(), 100L, false, 1000L, 1, 1024));
        pool.start();
        ItemSource itemSource = pool.getPooled();
        pool.stop();
        Assert.assertEquals((long)0L, (long)pool.getAvailableSize());
        itemSource.release();
        Assert.assertEquals((long)0L, (long)pool.getAvailableSize());
    }

    @Test
    public void lifecycleStopCausesReturnedBuffersRelease() throws PoolResourceException {
        BufferedItemSourcePool pool = (BufferedItemSourcePool)Mockito.spy((Object)new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)UnlimitedResizePolicy.newBuilder().withResizeFactor(1.0).build(), 100L, false, 1000L, 1, 1024));
        pool.start();
        ItemSource itemSource = (ItemSource)Mockito.spy((Object)pool.getPooled());
        ByteBuf byteBuf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)itemSource.getSource()).thenReturn((Object)byteBuf);
        pool.stop();
        Assert.assertEquals((long)0L, (long)pool.getAvailableSize());
        itemSource.release();
        ((ByteBuf)Mockito.verify((Object)byteBuf)).release();
    }

    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    private LifeCycle createLifeCycleTestObject() {
        return this.createDefaultTestBufferedItemSourcePool(false);
    }

    public BufferedItemSourcePool createDefaultTestBufferedItemSourcePool(boolean isMonitored) {
        return BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(10, isMonitored);
    }

    public BufferedItemSourcePool createDefaultTestBufferedItemSourcePool(boolean isMonitored, ScheduledExecutorService spiedExecutor) {
        return BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(10, isMonitored, spiedExecutor);
    }

    public static BufferedItemSourcePool createDefaultTestBufferedItemSourcePool(int initialSize, boolean monitored) {
        return new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)UnlimitedResizePolicy.newBuilder().build(), 100L, monitored, 1000L, initialSize, 1024);
    }

    static BufferedItemSourcePool createDefaultTestBufferedItemSourcePool(int initialSize, boolean monitored, final ScheduledExecutorService mockedExecutor) {
        UnlimitedResizePolicy resizePolicy = UnlimitedResizePolicy.newBuilder().build();
        return new BufferedItemSourcePool(DEFAULT_TEST_ITEM_POOL_NAME, byteBufAllocator, (ResizePolicy)resizePolicy, 100L, monitored, 1000L, initialSize, 1024){

            ScheduledExecutorService createExecutor() {
                return mockedExecutor;
            }

            ScheduledExecutorService createExecutor(String threadName) {
                return this.createExecutor();
            }
        };
    }

    static {
        System.setProperty("io.netty.allocator.maxOrder", "2");
        byteBufAllocator = new UnpooledByteBufAllocator(false, false, false);
    }
}

