/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.appenders.log4j2.elasticsearch.BufferedItemSource;
import org.appenders.log4j2.elasticsearch.BufferedItemSourcePoolTest;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ReleaseCallback;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class BufferedItemSourceTest {
    @Test
    public void doesNotChangeTheSource() {
        CompositeByteBuf expectedSource = BufferedItemSourceTest.createDefaultTestByteBuf();
        BufferedItemSource itemSource = new BufferedItemSource((ByteBuf)expectedSource, (ReleaseCallback)Mockito.mock(ReleaseCallback.class));
        Object actualSource = itemSource.getSource();
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        Assert.assertTrue((expectedSource == actualSource ? 1 : 0) != 0);
    }

    @Test
    public void releaseDelegatesToGivenCallback() {
        ReleaseCallback callback = (ReleaseCallback)Mockito.mock(ReleaseCallback.class);
        CompositeByteBuf byteBuf = BufferedItemSourceTest.createDefaultTestByteBuf();
        BufferedItemSource source = new BufferedItemSource((ByteBuf)byteBuf, callback);
        source.release();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ItemSource.class);
        ((ReleaseCallback)Mockito.verify((Object)callback)).completed((ItemSource)captor.capture());
        Assert.assertEquals((Object)source, (Object)captor.getValue());
        Assert.assertTrue((source.getSource() == ((ItemSource)captor.getValue()).getSource() ? 1 : 0) != 0);
    }

    @Test
    public void releaseResetsTheSource() {
        ReleaseCallback callback = (ReleaseCallback)Mockito.mock(ReleaseCallback.class);
        CompositeByteBuf byteBuf = (CompositeByteBuf)Mockito.spy((Object)BufferedItemSourceTest.createDefaultTestByteBuf());
        BufferedItemSource source = new BufferedItemSource((ByteBuf)byteBuf, callback);
        source.release();
        ((CompositeByteBuf)Mockito.verify((Object)byteBuf)).clear();
    }

    public static CompositeByteBuf createDefaultTestByteBuf() {
        return new CompositeByteBuf((ByteBufAllocator)BufferedItemSourcePoolTest.byteBufAllocator, false, 2);
    }

    static {
        System.setProperty("io.netty.allocator.maxOrder", "7");
    }
}

