/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.BulkEmitter;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BulkEmitterTest {
    public static final int LARGE_TEST_INTERVAL = 10000;
    public static final int TEST_BATCH_SIZE = 2;
    public static final String TEST_DATA = "dummyData";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void interruptedExceptionIsHandled() throws InterruptedException {
        final int slackTime = 10000;
        Function listener = (Function)Mockito.spy((Object)new Function<Collection, Boolean>(){

            @Override
            public Boolean apply(Collection collection) {
                try {
                    Thread.currentThread();
                    Thread.sleep(slackTime);
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                return true;
            }
        });
        BulkEmitter emitter = new BulkEmitter(1, 10000, (BatchOperations)new BatchOperations<Collection>(){

            public Object createBatchItem(String indexName, Object source) {
                return source;
            }

            public Object createBatchItem(String indexName, ItemSource source) {
                return source;
            }

            public BatchBuilder<Collection> createBatchBuilder() {
                return BulkEmitterTest.this.createTestBatchBuilder();
            }
        });
        emitter.addListener(listener);
        Thread t1 = new Thread(() -> emitter.add((Object)0));
        Thread t2 = new Thread(() -> emitter.add((Object)1));
        t1.start();
        Thread.currentThread();
        Thread.sleep(100L);
        t2.start();
        Thread.currentThread();
        Thread.sleep(100L);
        t2.interrupt();
        ((Function)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).apply(Matchers.any());
    }

    @Test
    public void threadsAwaitingAtLatchAreEventuallyReleased() {
        final int slackTime = 100;
        Function listener = (Function)Mockito.spy((Object)new Function<Collection, Boolean>(){

            @Override
            public Boolean apply(Collection collection) {
                try {
                    Thread.currentThread();
                    Thread.sleep(slackTime);
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                return true;
            }
        });
        BulkEmitter emitter = new BulkEmitter(1, 10000, (BatchOperations)new BatchOperations<Collection>(){

            public Object createBatchItem(String indexName, Object source) {
                return source;
            }

            public Object createBatchItem(String indexName, ItemSource source) {
                return source;
            }

            public BatchBuilder<Collection> createBatchBuilder() {
                return BulkEmitterTest.this.createTestBatchBuilder();
            }
        });
        emitter.addListener(listener);
        Thread t1 = new Thread(() -> emitter.add((Object)0));
        Thread t2 = new Thread(() -> emitter.add((Object)1));
        t1.start();
        long start = System.currentTimeMillis();
        t2.run();
        long end = System.currentTimeMillis();
        ((Function)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).apply(Matchers.any());
        System.out.println(end - start);
        Assert.assertTrue((end - start >= (long)slackTime ? 1 : 0) != 0);
    }

    private BatchBuilder<Collection> createTestBatchBuilder() {
        return new BatchBuilder<Collection>(){
            Collection items = new ConcurrentLinkedQueue();

            public void add(Object item) {
                this.items.add(item);
            }

            public Collection build() {
                Iterator iterator = this.items.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
                return this.items;
            }
        };
    }

    @Test
    public void notifiesOnBatchWithGivenSize() {
        int batchSize = 3;
        BulkEmitter emitter = BulkEmitterTest.createTestBulkEmitter(batchSize, 10000, new TestBatchOperations());
        Function<TestBatch, Boolean> dummyObserver = this.dummyObserver();
        emitter.addListener(dummyObserver);
        for (int ii = 0; ii < batchSize; ++ii) {
            emitter.add((Object)new TestBatchItem(TEST_DATA));
        }
        ArgumentCaptor captor = ArgumentCaptor.forClass(TestBatch.class);
        ((Function)Mockito.verify(dummyObserver, (VerificationMode)Mockito.times((int)1))).apply(captor.capture());
        Assert.assertEquals((long)batchSize, (long)((TestBatch)captor.getValue()).items.size());
    }

    @Test
    public void notifiesOnEveryCompletedBatch() throws InterruptedException {
        BulkEmitter emitter = BulkEmitterTest.createTestBulkEmitter(2, 10000, new TestBatchOperations());
        Function<TestBatch, Boolean> dummyObserver = this.dummyObserver();
        emitter.addListener(dummyObserver);
        int expectedNumberOfBatches = 4;
        for (int ii = 0; ii < 2 * expectedNumberOfBatches; ++ii) {
            emitter.add((Object)new TestBatchItem(TEST_DATA));
            Thread.sleep(100L);
        }
        ArgumentCaptor captor = ArgumentCaptor.forClass(TestBatch.class);
        ((Function)Mockito.verify(dummyObserver, (VerificationMode)Mockito.times((int)expectedNumberOfBatches))).apply(captor.capture());
        for (TestBatch batch : captor.getAllValues()) {
            Assert.assertEquals((long)2L, (long)batch.items.size());
        }
    }

    @Test
    public void listenerIsNotNotifiedWhenThereNoItemsToBatch() {
        BulkEmitter emitter = BulkEmitterTest.createTestBulkEmitter(2, 10000, new TestBatchOperations());
        Function<TestBatch, Boolean> dummyObserver = this.dummyObserver();
        emitter.addListener(dummyObserver);
        emitter.notifyListener();
        ((Function)Mockito.verify(dummyObserver, (VerificationMode)Mockito.never())).apply(Matchers.any());
    }

    @Test
    public void listenerIsNotifiedByScheduledTask() throws InterruptedException {
        BulkEmitter emitter = BulkEmitterTest.createTestBulkEmitter(2, 1000, new TestBatchOperations());
        Function<TestBatch, Boolean> dummyObserver = this.dummyObserver();
        emitter.addListener(dummyObserver);
        emitter.start();
        Assert.assertTrue((boolean)true);
        emitter.add(new Object());
        Thread.currentThread();
        Thread.sleep(2000L);
        ((Function)Mockito.verify(dummyObserver)).apply(Matchers.any());
    }

    @Test
    public void listenerIsNotifiedOnLifecycleStop() {
        BulkEmitter emitter = BulkEmitterTest.createTestBulkEmitter(2, 1000, new TestBatchOperations());
        Function<TestBatch, Boolean> dummyObserver = this.dummyObserver();
        emitter.addListener(dummyObserver);
        Assert.assertTrue((boolean)true);
        emitter.add(new Object());
        emitter.stop();
        ((Function)Mockito.verify(dummyObserver)).apply(Matchers.any());
    }

    @Test
    public void listenerIsNotNotifiedAfterLifecycleStopCauseSchedulerIsCancelled() throws InterruptedException {
        Assert.assertTrue((boolean)true);
        BulkEmitter emitter = BulkEmitterTest.createTestBulkEmitter(2, 10, new TestBatchOperations());
        Function<TestBatch, Boolean> dummyObserver = this.dummyObserver();
        emitter.addListener(dummyObserver);
        emitter.add(new Object());
        int invocations = Mockito.mockingDetails(dummyObserver).getInvocations().size();
        emitter.stop();
        Thread.sleep(50L);
        ((Function)Mockito.verify(dummyObserver, (VerificationMode)Mockito.times((int)(invocations + 1)))).apply(Matchers.any());
    }

    @Test
    public void lifecycleStart() {
        BulkEmitter lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        BulkEmitter lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    private BulkEmitter createLifeCycleTestObject() {
        return BulkEmitterTest.createTestBulkEmitter(2, 10000, new TestBatchOperations());
    }

    public static BulkEmitter createTestBulkEmitter(int batchSize, int interval, BatchOperations batchOperations) {
        BulkEmitter bulkEmitter = new BulkEmitter(batchSize, interval, batchOperations);
        return bulkEmitter;
    }

    private Function<TestBatch, Boolean> dummyObserver() {
        return (Function)Mockito.spy((Object)new DummyListener());
    }

    public static class TestBatch {
        public Collection<Object> items;

        public TestBatch(Collection<Object> items) {
            this.items = items;
        }
    }

    public static class TestBatchItem {
        private Object data;

        public TestBatchItem(Object data) {
            this.data = data;
        }

        public Object getData(Object o) {
            return this.data;
        }
    }

    public static class TestBatchBuilder
    implements BatchBuilder {
        private Collection<Object> items = new ConcurrentLinkedQueue<Object>();

        public void add(Object item) {
            this.items.add(item);
        }

        public Object build() {
            return new TestBatch(this.items);
        }
    }

    public static class TestBatchOperations
    implements BatchOperations {
        public Object createBatchItem(String indexName, Object source) {
            return new TestBatchItem(source);
        }

        public Object createBatchItem(String indexName, ItemSource source) {
            return new TestBatchItem(source.getSource());
        }

        public BatchBuilder createBatchBuilder() {
            return new TestBatchBuilder();
        }
    }

    class DummyListener
    implements Function<TestBatch, Boolean> {
        DummyListener() {
        }

        @Override
        public Boolean apply(TestBatch arg1) {
            return true;
        }
    }
}

