/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.appenders.log4j2.elasticsearch.AsyncBatchDelivery;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.ElasticsearchAppender;
import org.appenders.log4j2.elasticsearch.IndexNameFormatter;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemAppenderFactory;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceAppender;
import org.appenders.log4j2.elasticsearch.JacksonJsonLayout;
import org.appenders.log4j2.elasticsearch.StringAppender;
import org.appenders.log4j2.elasticsearch.mock.LifecycleTestHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;

public class ElasticsearchAppenderTest {
    private static final String TEST_APPENDER_NAME = "testAppender";

    @Test
    public void builderReturnsNonNullObject() {
        ElasticsearchAppender.Builder builder = ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder();
        ElasticsearchAppender appender = builder.build();
        Assert.assertNotNull((Object)appender);
    }

    @Test(expected=ConfigurationException.class)
    public void builderFailsWhenAppenderNameIsNull() {
        ElasticsearchAppender.Builder builder = ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder();
        builder.withName(null);
        builder.build();
    }

    @Test
    public void builderInitializesDefaultLayoutWhenLayoutIsNotProvided() throws IllegalAccessException {
        ElasticsearchAppender.Builder builder = ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder();
        builder.withLayout(null);
        ElasticsearchAppender appender = builder.build();
        Assert.assertNotNull((Object)PowerMockito.field(ElasticsearchAppender.class, (String)"layout").get(appender));
    }

    @Test(expected=ConfigurationException.class)
    public void builderFailsWhenBatchDeliveryIsNull() {
        ElasticsearchAppender.Builder builder = ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder();
        builder.withBatchDelivery(null);
        builder.build();
    }

    @Test
    public void appenderDelegatesToItemAppender() {
        ItemAppender itemAppender = (ItemAppender)Mockito.mock(ItemAppender.class);
        ItemAppenderFactory itemAppenderFactory = ElasticsearchAppenderTest.mockedItemAppenderFactory();
        Mockito.when((Object)itemAppenderFactory.createInstance(Matchers.anyBoolean(), (AbstractLayout)Matchers.any(AbstractLayout.class), (BatchDelivery)Matchers.any(BatchDelivery.class))).thenReturn((Object)itemAppender);
        TestElasticsearchAppender appender = this.createTestElasticsearchAppender(itemAppenderFactory);
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)System.currentTimeMillis());
        appender.append(logEvent);
        ((ItemAppender)Mockito.verify((Object)itemAppender, (VerificationMode)VerificationModeFactory.times((int)1))).append(Matchers.anyString(), Matchers.eq((Object)logEvent));
    }

    @Test
    public void appenderUsesProvidedLayoutWhenMessageOnlyIsSetToFalse() {
        AbstractStringLayout layout = (AbstractStringLayout)PowerMockito.mock(AbstractStringLayout.class);
        ElasticsearchAppender.Builder builder = ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder();
        builder.withMessageOnly(false);
        builder.withLayout((AbstractLayout)layout);
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        ElasticsearchAppender appender = builder.build();
        appender.append(logEvent);
        ArgumentCaptor captor = ArgumentCaptor.forClass(LogEvent.class);
        ((AbstractStringLayout)Mockito.verify((Object)layout, (VerificationMode)VerificationModeFactory.times((int)1))).toSerializable((LogEvent)captor.capture());
        Assert.assertEquals((Object)logEvent, (Object)captor.getValue());
    }

    @Test
    public void appenderUsesProvidedIndexNameFormatter() {
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        IndexNameFormatter indexNameFormatter = (IndexNameFormatter)Mockito.mock(IndexNameFormatter.class);
        Mockito.when((Object)indexNameFormatter.format((LogEvent)Matchers.any(LogEvent.class))).thenReturn((Object)"formattedIndexName");
        ElasticsearchAppender.Builder builder = ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder();
        builder.withBatchDelivery(batchDelivery);
        builder.withMessageOnly(false);
        builder.withIndexNameFormatter(indexNameFormatter);
        LogEvent logEvent = this.createTestLogEvent();
        ElasticsearchAppender appender = builder.build();
        appender.append(logEvent);
        ((BatchDelivery)Mockito.verify((Object)batchDelivery, (VerificationMode)VerificationModeFactory.times((int)1))).add((String)Matchers.eq((Object)"formattedIndexName"), (ItemSource)Matchers.any(ItemSource.class));
    }

    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    @Test
    public void lifecycleStartStartsItemAppender() {
        final ItemSourceAppender mockItemAppender = (ItemSourceAppender)Mockito.mock(ItemSourceAppender.class);
        ItemAppenderFactory itemAppenderFactory = new ItemAppenderFactory(){

            public ItemSourceAppender createInstance(boolean messageOnly, AbstractLayout layout, BatchDelivery batchDelivery) {
                return mockItemAppender;
            }
        };
        TestElasticsearchAppender appender = this.createTestElasticsearchAppender(itemAppenderFactory);
        appender.start();
        ((ItemSourceAppender)Mockito.verify((Object)mockItemAppender)).start();
    }

    @Test
    public void lifecycleStopStopsItemAppenderOnlyOnce() {
        final ItemSourceAppender mockItemAppender = (ItemSourceAppender)Mockito.mock(ItemSourceAppender.class);
        Mockito.when((Object)mockItemAppender.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        ItemAppenderFactory itemAppenderFactory = new ItemAppenderFactory(){

            public ItemSourceAppender createInstance(boolean messageOnly, AbstractLayout layout, BatchDelivery batchDelivery) {
                return mockItemAppender;
            }
        };
        TestElasticsearchAppender appender = this.createTestElasticsearchAppender(itemAppenderFactory);
        appender.stop();
        appender.stop();
        ((ItemSourceAppender)Mockito.verify((Object)mockItemAppender)).stop();
    }

    @Test
    public void lifecycleStopWithTimeoutStopsItemAppenderOnlyOnce() {
        final ItemSourceAppender mockItemAppender = (ItemSourceAppender)Mockito.mock(ItemSourceAppender.class);
        Mockito.when((Object)mockItemAppender.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        ItemAppenderFactory itemAppenderFactory = new ItemAppenderFactory(){

            public ItemSourceAppender createInstance(boolean messageOnly, AbstractLayout layout, BatchDelivery batchDelivery) {
                return mockItemAppender;
            }
        };
        TestElasticsearchAppender appender = this.createTestElasticsearchAppender(itemAppenderFactory);
        appender.stop(0L, TimeUnit.MILLISECONDS);
        appender.stop(0L, TimeUnit.MILLISECONDS);
        ((ItemSourceAppender)Mockito.verify((Object)mockItemAppender)).stop();
        Assert.assertFalse((boolean)appender.isStarted());
        Assert.assertTrue((boolean)appender.isStopped());
    }

    @Test
    public void lifecycleStopStopsItemSourceLayout() {
        final StringAppender mockItemAppender = (StringAppender)Mockito.mock(StringAppender.class);
        Mockito.when((Object)mockItemAppender.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        ItemAppenderFactory itemAppenderFactory = new ItemAppenderFactory(){

            public ItemAppender createInstance(boolean messageOnly, AbstractLayout layout, BatchDelivery batchDelivery) {
                return mockItemAppender;
            }
        };
        JacksonJsonLayout layout = (JacksonJsonLayout)Mockito.mock(JacksonJsonLayout.class);
        TestElasticsearchAppender appender = this.createTestElasticsearchAppender(itemAppenderFactory, (AbstractLayout)layout);
        appender.stop(0L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)appender.isStarted());
        Assert.assertTrue((boolean)appender.isStopped());
        ((JacksonJsonLayout)Mockito.verify((Object)layout)).stop();
    }

    @Test
    public void lifecycleStopDoesntInteractWithAbstractLayout() {
        final StringAppender mockItemAppender = (StringAppender)Mockito.mock(StringAppender.class);
        Mockito.when((Object)mockItemAppender.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        ItemAppenderFactory itemAppenderFactory = new ItemAppenderFactory(){

            public ItemAppender createInstance(boolean messageOnly, AbstractLayout layout, BatchDelivery batchDelivery) {
                return mockItemAppender;
            }
        };
        AbstractLayout abstractLayout = (AbstractLayout)Mockito.mock(AbstractLayout.class);
        TestElasticsearchAppender appender = this.createTestElasticsearchAppender(itemAppenderFactory, abstractLayout);
        appender.stop(0L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((Mockito.mockingDetails((Object)abstractLayout).getInvocations().size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)appender.isStarted());
        Assert.assertTrue((boolean)appender.isStopped());
    }

    private LifeCycle createLifeCycleTestObject() {
        return ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder((AbstractLayout)JacksonJsonLayout.newBuilder().build()).build();
    }

    private LogEvent createTestLogEvent() {
        return DefaultLogEventFactory.getInstance().createEvent("testLogger", null, this.getClass().getName(), Level.INFO, (Message)new SimpleMessage("testMessage"), null, null);
    }

    private TestElasticsearchAppender createTestElasticsearchAppender(ItemAppenderFactory mockItemAppenderFactory) {
        return this.createTestElasticsearchAppender(mockItemAppenderFactory, (AbstractLayout)JsonLayout.newBuilder().build());
    }

    private TestElasticsearchAppender createTestElasticsearchAppender(final ItemAppenderFactory mockItemAppenderFactory, AbstractLayout layout) {
        IndexNameFormatter indexNameFormatter = (IndexNameFormatter)Mockito.mock(IndexNameFormatter.class);
        Mockito.when((Object)indexNameFormatter.format((LogEvent)Matchers.any())).thenReturn((Object)UUID.randomUUID().toString());
        return new TestElasticsearchAppender(TEST_APPENDER_NAME, null, layout, false, (BatchDelivery)Mockito.mock(BatchDelivery.class), false, indexNameFormatter){

            @Override
            protected ItemAppenderFactory createItemAppenderFactory() {
                return mockItemAppenderFactory;
            }
        };
    }

    public static ElasticsearchAppender.Builder createTestElasticsearchAppenderBuilder() {
        return ElasticsearchAppenderTest.createTestElasticsearchAppenderBuilder(null);
    }

    public static ElasticsearchAppender.Builder createTestElasticsearchAppenderBuilder(AbstractLayout layout) {
        ElasticsearchAppender.Builder builder = ElasticsearchAppender.newBuilder().withName(TEST_APPENDER_NAME).withFilter((Filter)ThresholdFilter.createFilter((Level)Level.INFO, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY)).withIgnoreExceptions(false).withBatchDelivery((BatchDelivery)Mockito.mock(AsyncBatchDelivery.class)).withMessageOnly(false).withLayout(layout);
        IndexNameFormatter indexNameFormatter = (IndexNameFormatter)Mockito.mock(IndexNameFormatter.class);
        Mockito.when((Object)indexNameFormatter.format((LogEvent)Matchers.any(LogEvent.class))).thenReturn((Object)"testIndexName");
        builder.withIndexNameFormatter(indexNameFormatter);
        return builder;
    }

    private static ItemAppenderFactory mockedItemAppenderFactory() {
        return (ItemAppenderFactory)Mockito.mock(ItemAppenderFactory.class);
    }

    static class TestElasticsearchAppender
    extends ElasticsearchAppender {
        protected TestElasticsearchAppender(String name, Filter filter, AbstractLayout layout, boolean ignoreExceptions, BatchDelivery batchDelivery, boolean messageOnly, IndexNameFormatter indexNameFormatter) {
            super(name, filter, layout, ignoreExceptions, batchDelivery, messageOnly, indexNameFormatter);
        }

        protected ItemAppenderFactory createItemAppenderFactory() {
            return ElasticsearchAppenderTest.mockedItemAppenderFactory();
        }
    }
}

