/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.appenders.log4j2.elasticsearch.ExtendedObjectMapper;
import org.appenders.log4j2.elasticsearch.ExtendedObjectWriter;
import org.appenders.log4j2.elasticsearch.thirdparty.ReusableByteBufOutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExtendedObjectWriterTest {
    @Test
    public void returnsSameSerProvWhenNoNewSerializersCached() throws IOException {
        int expectedCalls = new Random().nextInt(100) + 2;
        ArrayList caught = new ArrayList();
        ExtendedObjectMapper mapper = new ExtendedObjectMapper(new JsonFactory());
        ExtendedObjectWriter writer = (ExtendedObjectWriter)Mockito.spy((Object)((ExtendedObjectWriter)mapper._newWriter(mapper.getSerializationConfig(), (JavaType)mapper.getTypeFactory().constructArrayType(Object.class), null)));
        Mockito.when((Object)writer._serializerProvider()).thenAnswer(invocationOnMock -> {
            DefaultSerializerProvider result = (DefaultSerializerProvider)invocationOnMock.callRealMethod();
            caught.add(result);
            return result;
        });
        for (int i = 0; i < expectedCalls; ++i) {
            writer.writeValue((OutputStream)new ReusableByteBufOutputStream((ByteBuf)Mockito.mock(ByteBuf.class)), null);
        }
        Assert.assertThat(caught, (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.is(caught.get(0))));
        ((ExtendedObjectWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)expectedCalls)))._serializerProvider();
    }

    @Test
    public void returnsNewSerProvNewWhenSerializersCached() throws IOException {
        int expectedCalls = new Random().nextInt(100) + 2;
        ArrayList caught = new ArrayList();
        ExtendedObjectMapper mapper = new ExtendedObjectMapper(new JsonFactory());
        ExtendedObjectWriter writer = (ExtendedObjectWriter)Mockito.spy((Object)((ExtendedObjectWriter)mapper._newWriter(mapper.getSerializationConfig(), mapper.getTypeFactory().constructType(Log4jLogEvent.class), null)));
        Mockito.when((Object)writer._serializerProvider()).thenAnswer(invocationOnMock -> {
            DefaultSerializerProvider result = (DefaultSerializerProvider)invocationOnMock.callRealMethod();
            caught.add(result);
            return result;
        });
        for (int i = 0; i < expectedCalls; ++i) {
            writer.writeValue((OutputStream)new ReusableByteBufOutputStream((ByteBuf)Mockito.mock(ByteBuf.class)), (Object)Log4jLogEvent.newBuilder().build());
        }
        Assert.assertEquals((long)2L, (long)new HashSet(caught).size());
        ((ExtendedObjectWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)expectedCalls)))._serializerProvider();
    }
}

