/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.File;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.junit.Assert;
import org.junit.Test;

public class IndexTemplateTest {
    public static final String TEST_INDEX_TEMPLATE = "testIndexTemplate";
    public static final String TEST_PATH = "classpath:indexTemplate.json";
    private static final String TEST_SOURCE = "{}";

    public static IndexTemplate.Builder createTestIndexTemplateBuilder() {
        IndexTemplate.Builder builder = IndexTemplate.newBuilder();
        builder.withName(TEST_INDEX_TEMPLATE).withPath(TEST_PATH);
        return builder;
    }

    @Test
    public void startsWhenSetupCorrectlyWithNameAndPath() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withName(TEST_INDEX_TEMPLATE).withPath(TEST_PATH);
        IndexTemplate indexTemplate = builder.build();
        Assert.assertNotNull((Object)indexTemplate);
        Assert.assertNotNull((Object)indexTemplate.getName());
        Assert.assertNotNull((Object)indexTemplate.getSource());
    }

    @Test
    public void startsWhenSetupCorrectlyWithNameAndSource() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withName(TEST_INDEX_TEMPLATE).withPath(null).withSource(TEST_SOURCE);
        IndexTemplate indexTemplate = builder.build();
        Assert.assertNotNull((Object)indexTemplate);
        Assert.assertNotNull((Object)indexTemplate.getName());
        Assert.assertNotNull((Object)indexTemplate.getSource());
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenNameIsNotSet() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withName(null);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenNeitherPathOrSourceIsSet() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath(null).withSource(null);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenBothPathAndSourceAreSet() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath(TEST_PATH).withSource(TEST_SOURCE);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenClasspathResourceDoesntExist() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath("classpath:nonExistentFile");
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenFileDoesntExist() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath("nonExistentFile");
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionOnInvalidProtocol() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath("~/nonExistentFile");
        builder.build();
    }

    @Test
    public void builderDoesntThrowExceptionWhenFileExists() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath(new File(ClassLoader.getSystemClassLoader().getResource("indexTemplate.json").getFile()).getAbsolutePath());
        builder.build();
    }
}

