/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.Serializable;
import java.util.UUID;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.message.Message;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemAppenderFactory;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceAppender;
import org.appenders.log4j2.elasticsearch.ItemSourceLayout;
import org.appenders.log4j2.elasticsearch.StringAppender;
import org.appenders.log4j2.elasticsearch.StringItemSource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ItemAppenderFactoryTest {
    @Captor
    private ArgumentCaptor<String> indexNameCaptor;
    @Captor
    private ArgumentCaptor<LogEvent> logEventCaptor;
    @Captor
    private ArgumentCaptor<Message> messageCaptor;
    @Captor
    private ArgumentCaptor<String> stringLogCaptor;
    @Captor
    private ArgumentCaptor<ItemSource> itemSourceCaptor;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void messageOnlyAbstractStringLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        AbstractStringLayout abstractStringLayout = (AbstractStringLayout)Mockito.mock(AbstractStringLayout.class);
        ItemAppender itemAppender = factory.createInstance(true, (AbstractLayout)abstractStringLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)message.getFormattedMessage()).thenReturn((Object)expectedMessage);
        Mockito.when((Object)logEvent.getMessage()).thenReturn((Object)message);
        itemAppender.append(formattedIndexName, (Object)logEvent);
        Assert.assertEquals(StringAppender.class, itemAppender.getClass());
        ((AbstractStringLayout)Mockito.verify((Object)abstractStringLayout, (VerificationMode)Mockito.never())).toSerializable((LogEvent)Matchers.any());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), this.stringLogCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)this.stringLogCaptor.getValue());
    }

    @Test
    public void nonMessageOnlyAbstractStringLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        AbstractStringLayout stringBasedLayout = (AbstractStringLayout)Mockito.mock(AbstractStringLayout.class);
        ItemAppender itemAppender = factory.createInstance(false, (AbstractLayout)stringBasedLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        Mockito.when((Object)stringBasedLayout.toSerializable((LogEvent)Matchers.any(LogEvent.class))).thenReturn((Object)expectedMessage);
        LogEvent logEvent = this.createDefaultTestLogEvent();
        itemAppender.append(formattedIndexName, (Object)logEvent);
        Assert.assertEquals(StringAppender.class, itemAppender.getClass());
        ((AbstractStringLayout)Mockito.verify((Object)stringBasedLayout)).toSerializable((LogEvent)this.logEventCaptor.capture());
        Assert.assertEquals((Object)logEvent, (Object)this.logEventCaptor.getValue());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), this.stringLogCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)this.stringLogCaptor.getValue());
    }

    @Test
    public void givenAbstractLayoutImplementingItemSourceLayoutDelegatesToItemSourceLayoutFactoryMethod() {
        ItemAppenderFactory factory = (ItemAppenderFactory)Mockito.spy((Object)new ItemAppenderFactory());
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        ItemSourceLayout itemSourceLayout = (ItemSourceLayout)Mockito.spy((Object)((Object)new TestItemSourceaLayout((Configuration)Mockito.mock(Configuration.class))));
        factory.createInstance(false, (AbstractLayout)itemSourceLayout, batchDelivery);
        ((ItemAppenderFactory)Mockito.verify((Object)factory)).createInstance(Matchers.eq((boolean)false), (ItemSourceLayout)Matchers.eq((Object)itemSourceLayout), (BatchDelivery)Matchers.eq((Object)batchDelivery));
    }

    @Test
    public void nonMessageOnlyItemSourceLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        ItemSourceLayout itemSourceLayout = (ItemSourceLayout)Mockito.spy((Object)((Object)new TestItemSourceaLayout((Configuration)Mockito.mock(Configuration.class))));
        ItemSourceAppender itemAppender = (ItemSourceAppender)factory.createInstance(false, (AbstractLayout)itemSourceLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        StringItemSource itemSource = new StringItemSource(expectedMessage);
        Mockito.when((Object)itemSourceLayout.serialize((LogEvent)Matchers.any(LogEvent.class))).thenReturn((Object)itemSource);
        LogEvent logEvent = this.createDefaultTestLogEvent();
        itemAppender.append(formattedIndexName, logEvent);
        Assert.assertEquals(ItemSourceAppender.class, itemAppender.getClass());
        ((ItemSourceLayout)Mockito.verify((Object)itemSourceLayout)).serialize((LogEvent)this.logEventCaptor.capture());
        Assert.assertEquals((Object)logEvent, (Object)this.logEventCaptor.getValue());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), (ItemSource)this.itemSourceCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)((ItemSource)this.itemSourceCaptor.getValue()).getSource());
    }

    @Test
    public void messageOnlyItemSourceLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        ItemSourceLayout itemSourceLayout = (ItemSourceLayout)Mockito.spy((Object)((Object)new TestItemSourceaLayout((Configuration)Mockito.mock(Configuration.class))));
        ItemSourceAppender itemAppender = (ItemSourceAppender)factory.createInstance(true, (AbstractLayout)itemSourceLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        StringItemSource itemSource = new StringItemSource(expectedMessage);
        Mockito.when((Object)itemSourceLayout.serialize((Message)Matchers.any(Message.class))).thenReturn((Object)itemSource);
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)logEvent.getMessage()).thenReturn((Object)message);
        itemAppender.append(formattedIndexName, logEvent);
        Assert.assertEquals(ItemSourceAppender.class, itemAppender.getClass());
        ((ItemSourceLayout)Mockito.verify((Object)itemSourceLayout)).serialize((Message)this.messageCaptor.capture());
        Assert.assertEquals((Object)message, (Object)this.messageCaptor.getValue());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), (ItemSource)this.itemSourceCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)((ItemSource)this.itemSourceCaptor.getValue()).getSource());
    }

    @Test
    public void unsupportedLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Unsupported layout");
        factory.createInstance(false, (AbstractLayout)Mockito.mock(AbstractLayout.class), (BatchDelivery)Mockito.mock(BatchDelivery.class));
    }

    private LogEvent createDefaultTestLogEvent() {
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        return logEvent;
    }

    private class TestItemSourceaLayout
    extends AbstractLayout
    implements ItemSourceLayout {
        public TestItemSourceaLayout(Configuration configuration) {
            super(configuration, null, null);
        }

        public byte[] toByteArray(LogEvent event) {
            return null;
        }

        public Serializable toSerializable(LogEvent event) {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public void encode(Object source, ByteBufferDestination destination) {
        }

        public ItemSource serialize(LogEvent event) {
            return null;
        }

        public ItemSource serialize(Message message) {
            return null;
        }
    }
}

