/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.UUID;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.BufferedItemSource;
import org.appenders.log4j2.elasticsearch.BufferedItemSourcePool;
import org.appenders.log4j2.elasticsearch.BufferedItemSourcePoolTest;
import org.appenders.log4j2.elasticsearch.BufferedItemSourceTest;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ResizePolicy;
import org.appenders.log4j2.elasticsearch.mock.LifecycleTestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PrepareForTest(value={ItemSourcePool.class, PooledItemSourceFactory.Builder.class})
@RunWith(value=PowerMockRunner.class)
public class PooledItemSourceFactoryTest {
    private static final int DEFAULT_TEST_POOL_SIZE = 10;
    private static final int DEFAULT_TEST_ITEM_SIZE_IN_BYTES = 512;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static PooledItemSourceFactory.Builder createDefaultTestSourceFactoryConfig() {
        return PooledItemSourceFactory.newBuilder().withInitialPoolSize(10).withItemSizeInBytes(512);
    }

    @Test
    public void builderBuildsSuccessfully() {
        PooledItemSourceFactory.Builder builder = PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig();
        PooledItemSourceFactory factory = builder.build();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void builderThrowsOnInitialPoolSizeZero() {
        PooledItemSourceFactory.Builder builder = PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig().withInitialPoolSize(0);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("initialPoolSize must be higher than 0");
        this.expectedException.expectMessage("PooledItemSourceFactory");
        builder.build();
    }

    @Test
    public void builderThrowsOnInitialPoolSizeLessThanZero() {
        PooledItemSourceFactory.Builder builder = PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig().withInitialPoolSize(-1);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("initialPoolSize must be higher than 0");
        this.expectedException.expectMessage("PooledItemSourceFactory");
        builder.build();
    }

    @Test
    public void builderThrowsOnItemSizeInBytesZero() {
        PooledItemSourceFactory.Builder builder = PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig().withItemSizeInBytes(0);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("itemSizeInBytes must be higher than 0");
        this.expectedException.expectMessage("PooledItemSourceFactory");
        builder.build();
    }

    @Test
    public void builderThrowsOnItemSizeInBytesLessThanZero() {
        PooledItemSourceFactory.Builder builder = PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig().withItemSizeInBytes(-1);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("itemSizeInBytes must be higher than 0");
        this.expectedException.expectMessage("PooledItemSourceFactory");
        builder.build();
    }

    @Test
    public void throwsWhenCreateCantGetPooledElement() throws PoolResourceException {
        ItemSourcePool mockedPool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        String expectedMessage = UUID.randomUUID().toString();
        Mockito.when((Object)mockedPool.getPooled()).thenThrow(new Throwable[]{new PoolResourceException(expectedMessage)});
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory(mockedPool);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(expectedMessage);
        pooledItemSourceFactory.create(Mockito.mock(LogEvent.class), new ObjectMapper().writerFor(LogEvent.class));
    }

    @Test
    public void throwsWhenCreateEmptySourceCantGetPooledElement() throws PoolResourceException {
        ItemSourcePool mockedPool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        String expectedMessage = UUID.randomUUID().toString();
        Mockito.when((Object)mockedPool.getPooled()).thenThrow(new Throwable[]{new PoolResourceException(expectedMessage)});
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory(mockedPool);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(expectedMessage);
        pooledItemSourceFactory.createEmptySource();
    }

    @Test
    public void isBufferedReturnsTrue() {
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory((ItemSourcePool)Mockito.mock(ItemSourcePool.class));
        boolean isBuffered = pooledItemSourceFactory.isBuffered();
        Assert.assertEquals((Object)true, (Object)isBuffered);
    }

    @Test
    public void createEmptySourceRemovesFromPool() throws PoolResourceException {
        ItemSourcePool mockedPool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory(mockedPool);
        pooledItemSourceFactory.createEmptySource();
        ((ItemSourcePool)Mockito.verify((Object)mockedPool)).getPooled();
    }

    @Test
    public void createRemovesFromPool() throws PoolResourceException {
        ItemSourcePool mockedPool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        CompositeByteBuf byteBuf = BufferedItemSourceTest.createDefaultTestByteBuf();
        BufferedItemSource bufferedItemSource = new BufferedItemSource((ByteBuf)byteBuf, source -> {});
        Mockito.when((Object)mockedPool.getPooled()).thenReturn((Object)bufferedItemSource);
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory(mockedPool);
        pooledItemSourceFactory.create(Mockito.mock(LogEvent.class), new ObjectMapper().writerFor(LogEvent.class));
        ((ItemSourcePool)Mockito.verify((Object)mockedPool)).getPooled();
    }

    @Test
    public void createWritesItemSource() throws IOException, PoolResourceException {
        ItemSourcePool mockedPool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        CompositeByteBuf byteBuf = BufferedItemSourceTest.createDefaultTestByteBuf();
        BufferedItemSource bufferedItemSource = new BufferedItemSource((ByteBuf)byteBuf, source -> {});
        Mockito.when((Object)mockedPool.getPooled()).thenReturn((Object)bufferedItemSource);
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory(mockedPool);
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        ObjectWriter objectWriter = (ObjectWriter)Mockito.spy((Object)new ObjectMapper().writerFor(LogEvent.class));
        pooledItemSourceFactory.create((Object)logEvent, objectWriter);
        ((ObjectWriter)Mockito.verify((Object)objectWriter)).writeValue((OutputStream)Matchers.any(OutputStream.class), Matchers.eq((Object)logEvent));
    }

    @Test
    public void createExceptionReleasesPooledElement() throws IOException, PoolResourceException {
        ItemSourcePool mockedPool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        CompositeByteBuf byteBuf = BufferedItemSourceTest.createDefaultTestByteBuf();
        ItemSource bufferedItemSource = (ItemSource)Mockito.spy((Object)new BufferedItemSource((ByteBuf)byteBuf, source -> {}));
        Mockito.when((Object)mockedPool.getPooled()).thenReturn((Object)bufferedItemSource);
        PooledItemSourceFactory pooledItemSourceFactory = new PooledItemSourceFactory(mockedPool);
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        ObjectWriter objectWriter = (ObjectWriter)Mockito.spy((Object)new ObjectMapper().writerFor(LogEvent.class));
        ((ObjectWriter)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("test exception")}).when((Object)objectWriter)).writeValue((OutputStream)Matchers.any(OutputStream.class), Matchers.eq((Object)logEvent));
        ItemSource result = null;
        Exception caught = null;
        try {
            result = pooledItemSourceFactory.create((Object)logEvent, objectWriter);
        }
        catch (Exception e) {
            caught = e;
        }
        Assert.assertNull((Object)result);
        ((ItemSource)Mockito.verify((Object)bufferedItemSource)).release();
        Assert.assertEquals(IllegalArgumentException.class, caught.getClass());
    }

    @Test
    public void builderConfiguresItemSourcePool() throws Exception {
        boolean monitored = true;
        long monitorTaskInterval = new Random().nextInt();
        long resizeTimeout = new Random().nextInt(1000) + 100;
        int initialPoolSize = new Random().nextInt(100) + 1;
        int itemSizeInBytes = new Random().nextInt(1024) + 1024;
        String poolName = UUID.randomUUID().toString();
        ResizePolicy resizePolicy = (ResizePolicy)Mockito.mock(ResizePolicy.class);
        PooledItemSourceFactory.Builder builder = ((PooledItemSourceFactory.Builder)PowerMockito.spy((Object)PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig())).withMonitored(monitored).withMonitorTaskInterval(monitorTaskInterval).withResizePolicy(resizePolicy).withResizeTimeout(resizeTimeout).withInitialPoolSize(initialPoolSize).withItemSizeInBytes(itemSizeInBytes).withPoolName(poolName);
        BufferedItemSourcePool pool = BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(10, monitored);
        PowerMockito.whenNew(BufferedItemSourcePool.class).withAnyArguments().thenReturn((Object)pool);
        builder.build();
        PowerMockito.verifyNew(BufferedItemSourcePool.class).withArguments(Matchers.eq((Object)poolName), new Object[]{Matchers.any(UnpooledByteBufAllocator.class), Matchers.eq((Object)resizePolicy), Matchers.eq((long)resizeTimeout), Matchers.eq((boolean)monitored), Matchers.eq((long)monitorTaskInterval), Matchers.eq((int)initialPoolSize), Matchers.eq((int)itemSizeInBytes)});
    }

    @Test
    public void lifecycleStopShutsDownPoolOnlyOnce() {
        ItemSourcePool pool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        Mockito.when((Object)pool.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        PooledItemSourceFactory.Builder sourceFactoryConfig = (PooledItemSourceFactory.Builder)Mockito.spy((Object)PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig());
        Mockito.when((Object)sourceFactoryConfig.configuredBufferedItemSourcePool()).thenReturn((Object)pool);
        PooledItemSourceFactory factory = sourceFactoryConfig.build();
        factory.start();
        factory.stop();
        factory.stop();
        ((ItemSourcePool)Mockito.verify((Object)pool)).stop();
    }

    @Test
    public void lifecycleStartStartsPoolOnlyOnce() {
        ItemSourcePool pool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        PooledItemSourceFactory.Builder sourceFactoryConfig = (PooledItemSourceFactory.Builder)Mockito.spy((Object)PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig());
        Mockito.when((Object)sourceFactoryConfig.configuredBufferedItemSourcePool()).thenReturn((Object)pool);
        Mockito.when((Object)pool.isStarted()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        PooledItemSourceFactory factory = sourceFactoryConfig.build();
        factory.start();
        factory.start();
        ((ItemSourcePool)Mockito.verify((Object)pool)).start();
    }

    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    private LifeCycle createLifeCycleTestObject() {
        return PooledItemSourceFactoryTest.createDefaultTestSourceFactoryConfig().build();
    }

    static {
        System.setProperty("io.netty.allocator.maxOrder", "2");
        System.setProperty("log4j2.disable.jmx", "true");
    }
}

