/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.StringAppender;
import org.appenders.log4j2.elasticsearch.mock.LifecycleTestHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class StringAppenderTest {
    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    @Test
    public void lifecycleStartStartsBatchDelivery() {
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        StringAppender itemAppender = new StringAppender(batchDelivery, logEvent -> null);
        itemAppender.start();
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).start();
    }

    @Test
    public void lifecycleStopStopsBatchDeliveryIfStarted() {
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        Mockito.when((Object)batchDelivery.isStarted()).thenReturn((Object)true);
        StringAppender itemAppender = new StringAppender(batchDelivery, logEvent -> null);
        itemAppender.stop();
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).stop();
    }

    @Test
    public void lifecycleStopStopsBatchDeliveryOnlyOnce() {
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        Mockito.when((Object)batchDelivery.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        StringAppender itemAppender = new StringAppender(batchDelivery, logEvent -> null);
        itemAppender.stop();
        itemAppender.stop();
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).stop();
    }

    private LifeCycle createLifeCycleTestObject() {
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        return new StringAppender(batchDelivery, logEvent -> null);
    }
}

