/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.logging.log4j.core.LogEvent;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.StringItemSourceFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class StringItemSourceFactoryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void builderBuildsSuccessfully() {
        StringItemSourceFactory.Builder builder = StringItemSourceFactory.newBuilder();
        StringItemSourceFactory factory = builder.build();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void createEmptySourceThrows() {
        StringItemSourceFactory factory = this.createDefaultTestStringItemSourceFactory();
        this.expectedException.expect(UnsupportedOperationException.class);
        factory.createEmptySource();
    }

    @Test
    public void createWritesItemSource() throws IOException {
        StringItemSourceFactory factory = this.createDefaultTestStringItemSourceFactory();
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        ObjectWriter objectWriter = (ObjectWriter)Mockito.spy((Object)new ObjectMapper().writerFor(LogEvent.class));
        ItemSource itemSource = factory.create((Object)logEvent, objectWriter);
        Assert.assertNotNull((Object)itemSource);
        ((ObjectWriter)Mockito.verify((Object)objectWriter)).writeValueAsString(Matchers.eq((Object)logEvent));
    }

    @Test
    public void createFailureIsHandled() throws IOException {
        StringItemSourceFactory factory = this.createDefaultTestStringItemSourceFactory();
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        ObjectWriter objectWriter = (ObjectWriter)Mockito.spy((Object)new ObjectMapper().writerFor(LogEvent.class));
        ((ObjectWriter)Mockito.doThrow((Throwable[])new Throwable[]{JsonMappingException.fromUnexpectedIOE((IOException)new IOException("test exception"))}).when((Object)objectWriter)).writeValueAsString(Matchers.eq((Object)logEvent));
        ItemSource itemSource = factory.create((Object)logEvent, objectWriter);
        Assert.assertNull((Object)itemSource);
    }

    @Test
    public void isBufferedReturnsFalse() {
        StringItemSourceFactory.Builder builder = StringItemSourceFactory.newBuilder();
        StringItemSourceFactory factory = builder.build();
        Assert.assertEquals((Object)false, (Object)factory.isBuffered());
    }

    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    private LifeCycle createLifeCycleTestObject() {
        return this.createDefaultTestStringItemSourceFactory();
    }

    private StringItemSourceFactory createDefaultTestStringItemSourceFactory() {
        return StringItemSourceFactory.newBuilder().build();
    }
}

