/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.BulkEmitterTest;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.TestClient;
import org.appenders.log4j2.elasticsearch.TestResultHandler;

public class TestHttpObjectFactory
implements ClientObjectFactory<TestClient, BulkEmitterTest.TestBatch> {
    private final Collection<String> serverUris;
    private final int connTimeout;
    private final int readTimeout;
    private final int maxTotalConnections;
    private final int defaultMaxTotalConnectionsPerRoute;
    private final boolean discoveryEnabled;

    protected TestHttpObjectFactory(Collection<String> serverUris, int connTimeout, int readTimeout, int maxTotalConnections, int defaultMaxTotalConnectionPerRoute, boolean discoveryEnabled) {
        this.serverUris = serverUris;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.maxTotalConnections = maxTotalConnections;
        this.defaultMaxTotalConnectionsPerRoute = defaultMaxTotalConnectionPerRoute;
        this.discoveryEnabled = discoveryEnabled;
    }

    public Collection<String> getServerList() {
        return new ArrayList<String>(this.serverUris);
    }

    public TestClient createClient() {
        return new TestClient();
    }

    public Function<BulkEmitterTest.TestBatch, Boolean> createBatchListener(final FailoverPolicy failoverPolicy) {
        return new Function<BulkEmitterTest.TestBatch, Boolean>(){
            private Function<BulkEmitterTest.TestBatch, Boolean> failureHandler;
            private TestClient client;
            {
                this.failureHandler = TestHttpObjectFactory.this.createFailureHandler(failoverPolicy);
                this.client = TestHttpObjectFactory.this.createClient();
            }

            @Override
            public Boolean apply(BulkEmitterTest.TestBatch bulk) {
                TestResultHandler<Object> jestResultHandler = TestHttpObjectFactory.this.createResultHandler(bulk, this.failureHandler);
                this.client.executeAsync(bulk, jestResultHandler);
                return true;
            }
        };
    }

    public Function<BulkEmitterTest.TestBatch, Boolean> createFailureHandler(FailoverPolicy failover) {
        return bulk -> {
            bulk.items.forEach(failedItem -> failover.deliver(failedItem));
            return true;
        };
    }

    public BatchOperations<BulkEmitterTest.TestBatch> createBatchOperations() {
        return new BulkEmitterTest.TestBatchOperations();
    }

    public void execute(IndexTemplate indexTemplate) {
    }

    public void addOperation(Operation operation) {
        try {
            operation.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TestResultHandler<Object> createResultHandler(BulkEmitterTest.TestBatch bulk, Function<BulkEmitterTest.TestBatch, Boolean> failureHandler) {
        return new TestResultHandler<Object>(){};
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<TestHttpObjectFactory> {
        @PluginBuilderAttribute
        @Required(message="No serverUris provided for JestClientConfig")
        private String serverUris;
        @PluginBuilderAttribute
        private int connTimeout = -1;
        @PluginBuilderAttribute
        private int readTimeout = -1;
        @PluginBuilderAttribute
        private int maxTotalConnection = 40;
        @PluginBuilderAttribute
        private int defaultMaxTotalConnectionPerRoute = 4;
        @PluginBuilderAttribute
        private boolean discoveryEnabled;

        public TestHttpObjectFactory build() {
            if (this.serverUris == null) {
                throw new ConfigurationException("No serverUris provided for JestClientConfig");
            }
            return new TestHttpObjectFactory(Arrays.asList(this.serverUris.split(";")), this.connTimeout, this.readTimeout, this.maxTotalConnection, this.defaultMaxTotalConnectionPerRoute, this.discoveryEnabled);
        }

        public Builder withServerUris(String serverUris) {
            this.serverUris = serverUris;
            return this;
        }

        public void withMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
        }

        public void withDefaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
        }

        public void withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
        }

        public void withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void withDiscoveryEnabled(boolean discoveryEnabled) {
            this.discoveryEnabled = discoveryEnabled;
        }
    }
}

