/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.BufferedItemSourcePoolTest;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.UnlimitedResizePolicy;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UnlimitedResizePolicyTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void builderBuildsSuccessfully() {
        UnlimitedResizePolicy.Builder builder = UnlimitedResizePolicy.newBuilder();
        UnlimitedResizePolicy policy = builder.build();
        Assert.assertNotNull((Object)policy);
    }

    @Test
    public void builderThrowsWhenResizeFactorIsZero() {
        UnlimitedResizePolicy.Builder builder = UnlimitedResizePolicy.newBuilder();
        builder.withResizeFactor(0.0);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("must be higher than 0");
        builder.build();
    }

    @Test
    public void builderThrowsWhenResizeFactorIsLowerThanZero() {
        UnlimitedResizePolicy.Builder builder = UnlimitedResizePolicy.newBuilder();
        builder.withResizeFactor(-0.1);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("must be higher than 0");
        builder.build();
    }

    @Test
    public void builderThrowsWhenResizeFactorIsHigherThanOne() {
        UnlimitedResizePolicy.Builder builder = UnlimitedResizePolicy.newBuilder();
        builder.withResizeFactor(1.01);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("must be lower or equal 1");
        builder.build();
    }

    @Test
    public void increaseThrowsWhenResizeWouldNotTakeAnyEffect() {
        UnlimitedResizePolicy policy = UnlimitedResizePolicy.newBuilder().withResizeFactor(0.1).build();
        ItemSourcePool pool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        Integer initialPoolSize = 5;
        Mockito.when((Object)pool.getInitialSize()).thenReturn((Object)initialPoolSize);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("will not resize given pool");
        policy.increase(pool);
    }

    @Test
    public void increaseIncrementsPoolSizeByResizeFactorMultipliedByInitialPoolSize() {
        double resizeFactor = 0.2;
        UnlimitedResizePolicy policy = UnlimitedResizePolicy.newBuilder().withResizeFactor(resizeFactor).build();
        int initialPoolSize = 10;
        ItemSourcePool pool = (ItemSourcePool)Mockito.mock(ItemSourcePool.class);
        Mockito.when((Object)pool.getInitialSize()).thenReturn((Object)initialPoolSize);
        boolean resized = policy.increase(pool);
        Assert.assertTrue((boolean)resized);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        ((ItemSourcePool)Mockito.verify((Object)pool)).incrementPoolSize(((Integer)captor.capture()).intValue());
        Assert.assertEquals((Object)((int)((double)initialPoolSize * resizeFactor)), (Object)captor.getValue());
    }

    @Test
    public void decreaseShrinksPoolByTotalSizeMultipliedByResizeFactor() {
        int initialSize = 50;
        int additionalSize = 50;
        int expectedResizedTotalSize = 80;
        double resizeFactor = 0.2;
        UnlimitedResizePolicy resizePolicy = UnlimitedResizePolicy.newBuilder().withResizeFactor(resizeFactor).build();
        ItemSourcePool pool = (ItemSourcePool)Mockito.spy((Object)BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(initialSize, true));
        pool.start();
        pool.incrementPoolSize(additionalSize);
        boolean resized = resizePolicy.decrease(pool);
        Assert.assertTrue((boolean)resized);
        Assert.assertEquals((long)expectedResizedTotalSize, (long)pool.getTotalSize());
    }

    @Test
    public void decreaseNeverShrinksBelowInitialSize() throws PoolResourceException {
        int initialSize = 40;
        int additionalSize = 60;
        double resizeFactor = 0.75;
        int expectedResizedTotalSize = initialSize + 5;
        UnlimitedResizePolicy resizePolicy = UnlimitedResizePolicy.newBuilder().withResizeFactor(resizeFactor).build();
        ItemSourcePool pool = (ItemSourcePool)Mockito.spy((Object)BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(initialSize, true));
        pool.start();
        pool.incrementPoolSize(additionalSize);
        for (int ii = 0; ii < 5; ++ii) {
            pool.getPooled();
        }
        boolean resized = resizePolicy.decrease(pool);
        Assert.assertTrue((boolean)resized);
        Assert.assertEquals((long)expectedResizedTotalSize, (long)pool.getTotalSize());
        ((ItemSourcePool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)55))).remove();
    }

    @Test
    public void decreaseNeverShrinksWhenResizeWouldBeHigherThanAvailableSize() throws PoolResourceException {
        int initialSize = 40;
        int additionalSize = 60;
        double resizeFactor = 0.55;
        int expectedResizedTotalSize = initialSize + additionalSize;
        UnlimitedResizePolicy resizePolicy = UnlimitedResizePolicy.newBuilder().withResizeFactor(resizeFactor).build();
        ItemSourcePool pool = (ItemSourcePool)Mockito.spy((Object)BufferedItemSourcePoolTest.createDefaultTestBufferedItemSourcePool(initialSize, true));
        pool.start();
        pool.incrementPoolSize(additionalSize);
        for (int ii = 0; ii < 50; ++ii) {
            pool.getPooled();
        }
        boolean resized = resizePolicy.decrease(pool);
        Assert.assertFalse((boolean)resized);
        Assert.assertEquals((long)expectedResizedTotalSize, (long)pool.getTotalSize());
        ((ItemSourcePool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)0))).remove();
    }
}

